@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin

import com.pulumi.aws.ses.EventDestinationArgs.builder
import com.pulumi.aws.ses.kotlin.inputs.EventDestinationCloudwatchDestinationArgs
import com.pulumi.aws.ses.kotlin.inputs.EventDestinationCloudwatchDestinationArgsBuilder
import com.pulumi.aws.ses.kotlin.inputs.EventDestinationKinesisDestinationArgs
import com.pulumi.aws.ses.kotlin.inputs.EventDestinationKinesisDestinationArgsBuilder
import com.pulumi.aws.ses.kotlin.inputs.EventDestinationSnsDestinationArgs
import com.pulumi.aws.ses.kotlin.inputs.EventDestinationSnsDestinationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an SES event destination
 * ## Example Usage
 * ### CloudWatch Destination
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.EventDestination;
 * import com.pulumi.aws.ses.EventDestinationArgs;
 * import com.pulumi.aws.ses.inputs.EventDestinationCloudwatchDestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cloudwatch = new EventDestination("cloudwatch", EventDestinationArgs.builder()
 *             .configurationSetName(aws_ses_configuration_set.example().name())
 *             .enabled(true)
 *             .matchingTypes(
 *                 "bounce",
 *                 "send")
 *             .cloudwatchDestinations(EventDestinationCloudwatchDestinationArgs.builder()
 *                 .defaultValue("default")
 *                 .dimensionName("dimension")
 *                 .valueSource("emailHeader")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Kinesis Destination
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.EventDestination;
 * import com.pulumi.aws.ses.EventDestinationArgs;
 * import com.pulumi.aws.ses.inputs.EventDestinationKinesisDestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var kinesis = new EventDestination("kinesis", EventDestinationArgs.builder()
 *             .configurationSetName(aws_ses_configuration_set.example().name())
 *             .enabled(true)
 *             .matchingTypes(
 *                 "bounce",
 *                 "send")
 *             .kinesisDestination(EventDestinationKinesisDestinationArgs.builder()
 *                 .streamArn(aws_kinesis_firehose_delivery_stream.example().arn())
 *                 .roleArn(aws_iam_role.example().arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### SNS Destination
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.EventDestination;
 * import com.pulumi.aws.ses.EventDestinationArgs;
 * import com.pulumi.aws.ses.inputs.EventDestinationSnsDestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sns = new EventDestination("sns", EventDestinationArgs.builder()
 *             .configurationSetName(aws_ses_configuration_set.example().name())
 *             .enabled(true)
 *             .matchingTypes(
 *                 "bounce",
 *                 "send")
 *             .snsDestination(EventDestinationSnsDestinationArgs.builder()
 *                 .topicArn(aws_sns_topic.example().arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SES event destinations using `configuration_set_name` together with the event destination's `name`. For example:
 * ```sh
 *  $ pulumi import aws:ses/eventDestination:EventDestination sns some-configuration-set-test/event-destination-sns
 * ```
 * @property cloudwatchDestinations CloudWatch destination for the events
 * @property configurationSetName The name of the configuration set
 * @property enabled If true, the event destination will be enabled
 * @property kinesisDestination Send the events to a kinesis firehose destination
 * @property matchingTypes A list of matching types. May be any of `"send"`, `"reject"`, `"bounce"`, `"complaint"`, `"delivery"`, `"open"`, `"click"`, or `"renderingFailure"`.
 * @property name The name of the event destination
 * @property snsDestination Send the events to an SNS Topic destination
 * > **NOTE:** You can specify `"cloudwatch_destination"` or `"kinesis_destination"` but not both
 */
public data class EventDestinationArgs(
    public val cloudwatchDestinations: Output<List<EventDestinationCloudwatchDestinationArgs>>? =
        null,
    public val configurationSetName: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val kinesisDestination: Output<EventDestinationKinesisDestinationArgs>? = null,
    public val matchingTypes: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val snsDestination: Output<EventDestinationSnsDestinationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.ses.EventDestinationArgs> {
    override fun toJava(): com.pulumi.aws.ses.EventDestinationArgs =
        com.pulumi.aws.ses.EventDestinationArgs.builder()
            .cloudwatchDestinations(
                cloudwatchDestinations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .configurationSetName(configurationSetName?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .kinesisDestination(
                kinesisDestination?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .matchingTypes(matchingTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .snsDestination(
                snsDestination?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [EventDestinationArgs].
 */
@PulumiTagMarker
public class EventDestinationArgsBuilder internal constructor() {
    private var cloudwatchDestinations: Output<List<EventDestinationCloudwatchDestinationArgs>>? =
        null

    private var configurationSetName: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var kinesisDestination: Output<EventDestinationKinesisDestinationArgs>? = null

    private var matchingTypes: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var snsDestination: Output<EventDestinationSnsDestinationArgs>? = null

    /**
     * @param value CloudWatch destination for the events
     */
    @JvmName("wevyhtogpxudosax")
    public suspend
    fun cloudwatchDestinations(`value`: Output<List<EventDestinationCloudwatchDestinationArgs>>) {
        this.cloudwatchDestinations = value
    }

    @JvmName("rpbrkkhbrpulavci")
    public suspend fun cloudwatchDestinations(
        vararg
        values: Output<EventDestinationCloudwatchDestinationArgs>,
    ) {
        this.cloudwatchDestinations = Output.all(values.asList())
    }

    /**
     * @param values CloudWatch destination for the events
     */
    @JvmName("liojeyasthxsckpb")
    public suspend
    fun cloudwatchDestinations(values: List<Output<EventDestinationCloudwatchDestinationArgs>>) {
        this.cloudwatchDestinations = Output.all(values)
    }

    /**
     * @param value The name of the configuration set
     */
    @JvmName("qlegnjjqrhcnnuaj")
    public suspend fun configurationSetName(`value`: Output<String>) {
        this.configurationSetName = value
    }

    /**
     * @param value If true, the event destination will be enabled
     */
    @JvmName("erirkamuvkyjlgik")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Send the events to a kinesis firehose destination
     */
    @JvmName("chwpkuplnxyrscpj")
    public suspend fun kinesisDestination(`value`: Output<EventDestinationKinesisDestinationArgs>) {
        this.kinesisDestination = value
    }

    /**
     * @param value A list of matching types. May be any of `"send"`, `"reject"`, `"bounce"`, `"complaint"`, `"delivery"`, `"open"`, `"click"`, or `"renderingFailure"`.
     */
    @JvmName("rdhkhyqbvieoigyc")
    public suspend fun matchingTypes(`value`: Output<List<String>>) {
        this.matchingTypes = value
    }

    @JvmName("syvbiwtralfddrha")
    public suspend fun matchingTypes(vararg values: Output<String>) {
        this.matchingTypes = Output.all(values.asList())
    }

    /**
     * @param values A list of matching types. May be any of `"send"`, `"reject"`, `"bounce"`, `"complaint"`, `"delivery"`, `"open"`, `"click"`, or `"renderingFailure"`.
     */
    @JvmName("aralenhsbjnbceio")
    public suspend fun matchingTypes(values: List<Output<String>>) {
        this.matchingTypes = Output.all(values)
    }

    /**
     * @param value The name of the event destination
     */
    @JvmName("bojgvrnuhvoeenyk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Send the events to an SNS Topic destination
     * > **NOTE:** You can specify `"cloudwatch_destination"` or `"kinesis_destination"` but not both
     */
    @JvmName("xpwunrmahomrxmtt")
    public suspend fun snsDestination(`value`: Output<EventDestinationSnsDestinationArgs>) {
        this.snsDestination = value
    }

    /**
     * @param value CloudWatch destination for the events
     */
    @JvmName("octgbpetssqojfud")
    public suspend
    fun cloudwatchDestinations(`value`: List<EventDestinationCloudwatchDestinationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchDestinations = mapped
    }

    /**
     * @param argument CloudWatch destination for the events
     */
    @JvmName("ntxbkbdliwmasabv")
    public suspend
    fun cloudwatchDestinations(argument: List<suspend EventDestinationCloudwatchDestinationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EventDestinationCloudwatchDestinationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.cloudwatchDestinations = mapped
    }

    /**
     * @param argument CloudWatch destination for the events
     */
    @JvmName("hrhaffagsspxllln")
    public suspend fun cloudwatchDestinations(
        vararg
        argument: suspend EventDestinationCloudwatchDestinationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EventDestinationCloudwatchDestinationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.cloudwatchDestinations = mapped
    }

    /**
     * @param argument CloudWatch destination for the events
     */
    @JvmName("dgplttmvojjdtgya")
    public suspend
    fun cloudwatchDestinations(argument: suspend EventDestinationCloudwatchDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EventDestinationCloudwatchDestinationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.cloudwatchDestinations = mapped
    }

    /**
     * @param values CloudWatch destination for the events
     */
    @JvmName("jiedfrbetltpnxyu")
    public suspend fun cloudwatchDestinations(
        vararg
        values: EventDestinationCloudwatchDestinationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cloudwatchDestinations = mapped
    }

    /**
     * @param value The name of the configuration set
     */
    @JvmName("uypsuvytdebepysc")
    public suspend fun configurationSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationSetName = mapped
    }

    /**
     * @param value If true, the event destination will be enabled
     */
    @JvmName("mdgrdslmldtadinc")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Send the events to a kinesis firehose destination
     */
    @JvmName("albvjtaqxquanwmh")
    public suspend fun kinesisDestination(`value`: EventDestinationKinesisDestinationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kinesisDestination = mapped
    }

    /**
     * @param argument Send the events to a kinesis firehose destination
     */
    @JvmName("mbftdwlajtgnlmkm")
    public suspend
    fun kinesisDestination(argument: suspend EventDestinationKinesisDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = EventDestinationKinesisDestinationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.kinesisDestination = mapped
    }

    /**
     * @param value A list of matching types. May be any of `"send"`, `"reject"`, `"bounce"`, `"complaint"`, `"delivery"`, `"open"`, `"click"`, or `"renderingFailure"`.
     */
    @JvmName("gpkvbnigyrqjmrxe")
    public suspend fun matchingTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.matchingTypes = mapped
    }

    /**
     * @param values A list of matching types. May be any of `"send"`, `"reject"`, `"bounce"`, `"complaint"`, `"delivery"`, `"open"`, `"click"`, or `"renderingFailure"`.
     */
    @JvmName("iqfanqygfvnmhupt")
    public suspend fun matchingTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchingTypes = mapped
    }

    /**
     * @param value The name of the event destination
     */
    @JvmName("ullwejwdyqicycow")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Send the events to an SNS Topic destination
     * > **NOTE:** You can specify `"cloudwatch_destination"` or `"kinesis_destination"` but not both
     */
    @JvmName("wcnifkvfgqbimtkr")
    public suspend fun snsDestination(`value`: EventDestinationSnsDestinationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snsDestination = mapped
    }

    /**
     * @param argument Send the events to an SNS Topic destination
     * > **NOTE:** You can specify `"cloudwatch_destination"` or `"kinesis_destination"` but not both
     */
    @JvmName("fuhylvogdaastriw")
    public suspend
    fun snsDestination(argument: suspend EventDestinationSnsDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = EventDestinationSnsDestinationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.snsDestination = mapped
    }

    internal fun build(): EventDestinationArgs = EventDestinationArgs(
        cloudwatchDestinations = cloudwatchDestinations,
        configurationSetName = configurationSetName,
        enabled = enabled,
        kinesisDestination = kinesisDestination,
        matchingTypes = matchingTypes,
        name = name,
        snsDestination = snsDestination,
    )
}
