@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [IdentityNotificationTopic].
 */
@PulumiTagMarker
public class IdentityNotificationTopicResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IdentityNotificationTopicArgs = IdentityNotificationTopicArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IdentityNotificationTopicArgsBuilder.() -> Unit) {
        val builder = IdentityNotificationTopicArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): IdentityNotificationTopic {
        val builtJavaResource = com.pulumi.aws.ses.IdentityNotificationTopic(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return IdentityNotificationTopic(builtJavaResource)
    }
}

/**
 * Resource for managing SES Identity Notification Topics
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.IdentityNotificationTopic;
 * import com.pulumi.aws.ses.IdentityNotificationTopicArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new IdentityNotificationTopic("test", IdentityNotificationTopicArgs.builder()
 *             .topicArn(aws_sns_topic.example().arn())
 *             .notificationType("Bounce")
 *             .identity(aws_ses_domain_identity.example().domain())
 *             .includeOriginalHeaders(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Identity Notification Topics using the ID of the record. The ID is made up as `IDENTITY|TYPE` where `IDENTITY` is the SES Identity and `TYPE` is the Notification Type. For example:
 * ```sh
 *  $ pulumi import aws:ses/identityNotificationTopic:IdentityNotificationTopic test 'example.com|Bounce'
 * ```
 *
 */
public class IdentityNotificationTopic internal constructor(
    override val javaResource: com.pulumi.aws.ses.IdentityNotificationTopic,
) : KotlinCustomResource(javaResource, IdentityNotificationTopicMapper) {
    /**
     * The identity for which the Amazon SNS topic will be set. You can specify an identity by using its name or by using its Amazon Resource Name (ARN).
     */
    public val identity: Output<String>
        get() = javaResource.identity().applyValue({ args0 -> args0 })

    /**
     * Whether SES should include original email headers in SNS notifications of this type. `false` by default.
     */
    public val includeOriginalHeaders: Output<Boolean>?
        get() = javaResource.includeOriginalHeaders().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of notifications that will be published to the specified Amazon SNS topic. Valid Values: `Bounce`, `Complaint` or `Delivery`.
     */
    public val notificationType: Output<String>
        get() = javaResource.notificationType().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the Amazon SNS topic. Can be set to `""` (an empty string) to disable publishing.
     */
    public val topicArn: Output<String>?
        get() = javaResource.topicArn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object IdentityNotificationTopicMapper : ResourceMapper<IdentityNotificationTopic> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ses.IdentityNotificationTopic::class == javaResource::class

    override fun map(javaResource: Resource): IdentityNotificationTopic =
        IdentityNotificationTopic(javaResource as com.pulumi.aws.ses.IdentityNotificationTopic)
}

/**
 * @see [IdentityNotificationTopic].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IdentityNotificationTopic].
 */
public suspend fun identityNotificationTopic(
    name: String,
    block: suspend IdentityNotificationTopicResourceBuilder.() -> Unit,
): IdentityNotificationTopic {
    val builder = IdentityNotificationTopicResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IdentityNotificationTopic].
 * @param name The _unique_ name of the resulting resource.
 */
public fun identityNotificationTopic(name: String): IdentityNotificationTopic {
    val builder = IdentityNotificationTopicResourceBuilder()
    builder.name(name)
    return builder.build()
}
