@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin

import com.pulumi.aws.ses.IdentityPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages a SES Identity Policy. More information about SES Sending Authorization Policies can be found in the [SES Developer Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.DomainIdentity;
 * import com.pulumi.aws.ses.DomainIdentityArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.ses.IdentityPolicy;
 * import com.pulumi.aws.ses.IdentityPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleDomainIdentity = new DomainIdentity("exampleDomainIdentity", DomainIdentityArgs.builder()
 *             .domain("example.com")
 *             .build());
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions(
 *                     "SES:SendEmail",
 *                     "SES:SendRawEmail")
 *                 .resources(exampleDomainIdentity.arn())
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .identifiers("*")
 *                     .type("AWS")
 *                     .build())
 *                 .build())
 *             .build());
 *         var exampleIdentityPolicy = new IdentityPolicy("exampleIdentityPolicy", IdentityPolicyArgs.builder()
 *             .identity(exampleDomainIdentity.arn())
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(examplePolicyDocument -> examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SES Identity Policies using the identity and policy name, separated by a pipe character (`|`). For example:
 * ```sh
 *  $ pulumi import aws:ses/identityPolicy:IdentityPolicy example 'example.com|example'
 * ```
 * @property identity Name or Amazon Resource Name (ARN) of the SES Identity.
 * @property name Name of the policy.
 * @property policy JSON string of the policy.
 */
public data class IdentityPolicyArgs(
    public val identity: Output<String>? = null,
    public val name: Output<String>? = null,
    public val policy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ses.IdentityPolicyArgs> {
    override fun toJava(): com.pulumi.aws.ses.IdentityPolicyArgs =
        com.pulumi.aws.ses.IdentityPolicyArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IdentityPolicyArgs].
 */
@PulumiTagMarker
public class IdentityPolicyArgsBuilder internal constructor() {
    private var identity: Output<String>? = null

    private var name: Output<String>? = null

    private var policy: Output<String>? = null

    /**
     * @param value Name or Amazon Resource Name (ARN) of the SES Identity.
     */
    @JvmName("tvhveurxngnoaxdx")
    public suspend fun identity(`value`: Output<String>) {
        this.identity = value
    }

    /**
     * @param value Name of the policy.
     */
    @JvmName("oryokfqhatfpukjj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value JSON string of the policy.
     */
    @JvmName("rgcwmjnixwerkoho")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value Name or Amazon Resource Name (ARN) of the SES Identity.
     */
    @JvmName("wwjafseabsgxgqof")
    public suspend fun identity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param value Name of the policy.
     */
    @JvmName("gwfksmbctgnfbdkf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value JSON string of the policy.
     */
    @JvmName("ymejctyxupkrrngd")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    internal fun build(): IdentityPolicyArgs = IdentityPolicyArgs(
        identity = identity,
        name = name,
        policy = policy,
    )
}
