@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [MailFrom].
 */
@PulumiTagMarker
public class MailFromResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MailFromArgs = MailFromArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MailFromArgsBuilder.() -> Unit) {
        val builder = MailFromArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): MailFrom {
        val builtJavaResource = com.pulumi.aws.ses.MailFrom(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MailFrom(builtJavaResource)
    }
}

/**
 * Provides an SES domain MAIL FROM resource.
 * > **NOTE:** For the MAIL FROM domain to be fully usable, this resource should be paired with the aws.ses.DomainIdentity resource. To validate the MAIL FROM domain, a DNS MX record is required. To pass SPF checks, a DNS TXT record may also be required. See the [Amazon SES MAIL FROM documentation](https://docs.aws.amazon.com/ses/latest/dg/mail-from.html) for more information.
 * ## Example Usage
 * ### Domain Identity MAIL FROM
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.DomainIdentity;
 * import com.pulumi.aws.ses.DomainIdentityArgs;
 * import com.pulumi.aws.ses.MailFrom;
 * import com.pulumi.aws.ses.MailFromArgs;
 * import com.pulumi.aws.route53.Record;
 * import com.pulumi.aws.route53.RecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleDomainIdentity = new DomainIdentity("exampleDomainIdentity", DomainIdentityArgs.builder()
 *             .domain("example.com")
 *             .build());
 *         var exampleMailFrom = new MailFrom("exampleMailFrom", MailFromArgs.builder()
 *             .domain(exampleDomainIdentity.domain())
 *             .mailFromDomain(exampleDomainIdentity.domain().applyValue(domain -> String.format("bounce.%s", domain)))
 *             .build());
 *         var exampleSesDomainMailFromMx = new Record("exampleSesDomainMailFromMx", RecordArgs.builder()
 *             .zoneId(aws_route53_zone.example().id())
 *             .name(exampleMailFrom.mailFromDomain())
 *             .type("MX")
 *             .ttl("600")
 *             .records("10 feedback-smtp.us-east-1.amazonses.com")
 *             .build());
 *         var exampleSesDomainMailFromTxt = new Record("exampleSesDomainMailFromTxt", RecordArgs.builder()
 *             .zoneId(aws_route53_zone.example().id())
 *             .name(exampleMailFrom.mailFromDomain())
 *             .type("TXT")
 *             .ttl("600")
 *             .records("v=spf1 include:amazonses.com -all")
 *             .build());
 *     }
 * }
 * ```
 * ### Email Identity MAIL FROM
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.EmailIdentity;
 * import com.pulumi.aws.ses.EmailIdentityArgs;
 * import com.pulumi.aws.ses.MailFrom;
 * import com.pulumi.aws.ses.MailFromArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleEmailIdentity = new EmailIdentity("exampleEmailIdentity", EmailIdentityArgs.builder()
 *             .email("user@example.com")
 *             .build());
 *         var exampleMailFrom = new MailFrom("exampleMailFrom", MailFromArgs.builder()
 *             .domain(exampleEmailIdentity.email())
 *             .mailFromDomain("mail.example.com")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import MAIL FROM domain using the `domain` attribute. For example:
 * ```sh
 *  $ pulumi import aws:ses/mailFrom:MailFrom example example.com
 * ```
 *
 */
public class MailFrom internal constructor(
    override val javaResource: com.pulumi.aws.ses.MailFrom,
) : KotlinCustomResource(javaResource, MailFromMapper) {
    /**
     * The action that you want Amazon SES to take if it cannot successfully read the required MX record when you send an email. Defaults to `UseDefaultValue`. See the [SES API documentation](https://docs.aws.amazon.com/ses/latest/APIReference/API_SetIdentityMailFromDomain.html) for more information.
     */
    public val behaviorOnMxFailure: Output<String>?
        get() = javaResource.behaviorOnMxFailure().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Verified domain name or email identity to generate DKIM tokens for.
     */
    public val domain: Output<String>
        get() = javaResource.domain().applyValue({ args0 -> args0 })

    /**
     * Subdomain (of above domain) which is to be used as MAIL FROM address (Required for DMARC validation)
     * The following arguments are optional:
     */
    public val mailFromDomain: Output<String>
        get() = javaResource.mailFromDomain().applyValue({ args0 -> args0 })
}

public object MailFromMapper : ResourceMapper<MailFrom> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ses.MailFrom::class == javaResource::class

    override fun map(javaResource: Resource): MailFrom = MailFrom(
        javaResource as
            com.pulumi.aws.ses.MailFrom,
    )
}

/**
 * @see [MailFrom].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MailFrom].
 */
public suspend fun mailFrom(name: String, block: suspend MailFromResourceBuilder.() -> Unit):
    MailFrom {
    val builder = MailFromResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MailFrom].
 * @param name The _unique_ name of the resulting resource.
 */
public fun mailFrom(name: String): MailFrom {
    val builder = MailFromResourceBuilder()
    builder.name(name)
    return builder.build()
}
