@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin

import com.pulumi.aws.ses.MailFromArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an SES domain MAIL FROM resource.
 * > **NOTE:** For the MAIL FROM domain to be fully usable, this resource should be paired with the aws.ses.DomainIdentity resource. To validate the MAIL FROM domain, a DNS MX record is required. To pass SPF checks, a DNS TXT record may also be required. See the [Amazon SES MAIL FROM documentation](https://docs.aws.amazon.com/ses/latest/dg/mail-from.html) for more information.
 * ## Example Usage
 * ### Domain Identity MAIL FROM
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.DomainIdentity;
 * import com.pulumi.aws.ses.DomainIdentityArgs;
 * import com.pulumi.aws.ses.MailFrom;
 * import com.pulumi.aws.ses.MailFromArgs;
 * import com.pulumi.aws.route53.Record;
 * import com.pulumi.aws.route53.RecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleDomainIdentity = new DomainIdentity("exampleDomainIdentity", DomainIdentityArgs.builder()
 *             .domain("example.com")
 *             .build());
 *         var exampleMailFrom = new MailFrom("exampleMailFrom", MailFromArgs.builder()
 *             .domain(exampleDomainIdentity.domain())
 *             .mailFromDomain(exampleDomainIdentity.domain().applyValue(domain -> String.format("bounce.%s", domain)))
 *             .build());
 *         var exampleSesDomainMailFromMx = new Record("exampleSesDomainMailFromMx", RecordArgs.builder()
 *             .zoneId(aws_route53_zone.example().id())
 *             .name(exampleMailFrom.mailFromDomain())
 *             .type("MX")
 *             .ttl("600")
 *             .records("10 feedback-smtp.us-east-1.amazonses.com")
 *             .build());
 *         var exampleSesDomainMailFromTxt = new Record("exampleSesDomainMailFromTxt", RecordArgs.builder()
 *             .zoneId(aws_route53_zone.example().id())
 *             .name(exampleMailFrom.mailFromDomain())
 *             .type("TXT")
 *             .ttl("600")
 *             .records("v=spf1 include:amazonses.com -all")
 *             .build());
 *     }
 * }
 * ```
 * ### Email Identity MAIL FROM
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.EmailIdentity;
 * import com.pulumi.aws.ses.EmailIdentityArgs;
 * import com.pulumi.aws.ses.MailFrom;
 * import com.pulumi.aws.ses.MailFromArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleEmailIdentity = new EmailIdentity("exampleEmailIdentity", EmailIdentityArgs.builder()
 *             .email("user@example.com")
 *             .build());
 *         var exampleMailFrom = new MailFrom("exampleMailFrom", MailFromArgs.builder()
 *             .domain(exampleEmailIdentity.email())
 *             .mailFromDomain("mail.example.com")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import MAIL FROM domain using the `domain` attribute. For example:
 * ```sh
 *  $ pulumi import aws:ses/mailFrom:MailFrom example example.com
 * ```
 * @property behaviorOnMxFailure The action that you want Amazon SES to take if it cannot successfully read the required MX record when you send an email. Defaults to `UseDefaultValue`. See the [SES API documentation](https://docs.aws.amazon.com/ses/latest/APIReference/API_SetIdentityMailFromDomain.html) for more information.
 * @property domain Verified domain name or email identity to generate DKIM tokens for.
 * @property mailFromDomain Subdomain (of above domain) which is to be used as MAIL FROM address (Required for DMARC validation)
 * The following arguments are optional:
 */
public data class MailFromArgs(
    public val behaviorOnMxFailure: Output<String>? = null,
    public val domain: Output<String>? = null,
    public val mailFromDomain: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ses.MailFromArgs> {
    override fun toJava(): com.pulumi.aws.ses.MailFromArgs = com.pulumi.aws.ses.MailFromArgs.builder()
        .behaviorOnMxFailure(behaviorOnMxFailure?.applyValue({ args0 -> args0 }))
        .domain(domain?.applyValue({ args0 -> args0 }))
        .mailFromDomain(mailFromDomain?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MailFromArgs].
 */
@PulumiTagMarker
public class MailFromArgsBuilder internal constructor() {
    private var behaviorOnMxFailure: Output<String>? = null

    private var domain: Output<String>? = null

    private var mailFromDomain: Output<String>? = null

    /**
     * @param value The action that you want Amazon SES to take if it cannot successfully read the required MX record when you send an email. Defaults to `UseDefaultValue`. See the [SES API documentation](https://docs.aws.amazon.com/ses/latest/APIReference/API_SetIdentityMailFromDomain.html) for more information.
     */
    @JvmName("ufimorvmvqaeetcp")
    public suspend fun behaviorOnMxFailure(`value`: Output<String>) {
        this.behaviorOnMxFailure = value
    }

    /**
     * @param value Verified domain name or email identity to generate DKIM tokens for.
     */
    @JvmName("jbhopuhnrcxjkjey")
    public suspend fun domain(`value`: Output<String>) {
        this.domain = value
    }

    /**
     * @param value Subdomain (of above domain) which is to be used as MAIL FROM address (Required for DMARC validation)
     * The following arguments are optional:
     */
    @JvmName("dmwtroljhmefdrdn")
    public suspend fun mailFromDomain(`value`: Output<String>) {
        this.mailFromDomain = value
    }

    /**
     * @param value The action that you want Amazon SES to take if it cannot successfully read the required MX record when you send an email. Defaults to `UseDefaultValue`. See the [SES API documentation](https://docs.aws.amazon.com/ses/latest/APIReference/API_SetIdentityMailFromDomain.html) for more information.
     */
    @JvmName("mxljveythbfswqux")
    public suspend fun behaviorOnMxFailure(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.behaviorOnMxFailure = mapped
    }

    /**
     * @param value Verified domain name or email identity to generate DKIM tokens for.
     */
    @JvmName("qwpmhhsajpawjgak")
    public suspend fun domain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    /**
     * @param value Subdomain (of above domain) which is to be used as MAIL FROM address (Required for DMARC validation)
     * The following arguments are optional:
     */
    @JvmName("ptxjgaquxfitvbhg")
    public suspend fun mailFromDomain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mailFromDomain = mapped
    }

    internal fun build(): MailFromArgs = MailFromArgs(
        behaviorOnMxFailure = behaviorOnMxFailure,
        domain = domain,
        mailFromDomain = mailFromDomain,
    )
}
