@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ReceiptFilter].
 */
@PulumiTagMarker
public class ReceiptFilterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReceiptFilterArgs = ReceiptFilterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReceiptFilterArgsBuilder.() -> Unit) {
        val builder = ReceiptFilterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ReceiptFilter {
        val builtJavaResource = com.pulumi.aws.ses.ReceiptFilter(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ReceiptFilter(builtJavaResource)
    }
}

/**
 * Provides an SES receipt filter resource
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.ReceiptFilter;
 * import com.pulumi.aws.ses.ReceiptFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var filter = new ReceiptFilter("filter", ReceiptFilterArgs.builder()
 *             .cidr("10.10.10.10")
 *             .policy("Block")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SES Receipt Filter using their `name`. For example:
 * ```sh
 *  $ pulumi import aws:ses/receiptFilter:ReceiptFilter test some-filter
 * ```
 *
 */
public class ReceiptFilter internal constructor(
    override val javaResource: com.pulumi.aws.ses.ReceiptFilter,
) : KotlinCustomResource(javaResource, ReceiptFilterMapper) {
    /**
     * The SES receipt filter ARN.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The IP address or address range to filter, in CIDR notation
     */
    public val cidr: Output<String>
        get() = javaResource.cidr().applyValue({ args0 -> args0 })

    /**
     * The name of the filter
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Block or Allow
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })
}

public object ReceiptFilterMapper : ResourceMapper<ReceiptFilter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ses.ReceiptFilter::class == javaResource::class

    override fun map(javaResource: Resource): ReceiptFilter = ReceiptFilter(
        javaResource as
            com.pulumi.aws.ses.ReceiptFilter,
    )
}

/**
 * @see [ReceiptFilter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ReceiptFilter].
 */
public suspend fun receiptFilter(
    name: String,
    block: suspend ReceiptFilterResourceBuilder.() -> Unit,
): ReceiptFilter {
    val builder = ReceiptFilterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ReceiptFilter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun receiptFilter(name: String): ReceiptFilter {
    val builder = ReceiptFilterResourceBuilder()
    builder.name(name)
    return builder.build()
}
