@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin

import com.pulumi.aws.ses.ReceiptFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an SES receipt filter resource
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.ReceiptFilter;
 * import com.pulumi.aws.ses.ReceiptFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var filter = new ReceiptFilter("filter", ReceiptFilterArgs.builder()
 *             .cidr("10.10.10.10")
 *             .policy("Block")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SES Receipt Filter using their `name`. For example:
 * ```sh
 *  $ pulumi import aws:ses/receiptFilter:ReceiptFilter test some-filter
 * ```
 * @property cidr The IP address or address range to filter, in CIDR notation
 * @property name The name of the filter
 * @property policy Block or Allow
 */
public data class ReceiptFilterArgs(
    public val cidr: Output<String>? = null,
    public val name: Output<String>? = null,
    public val policy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ses.ReceiptFilterArgs> {
    override fun toJava(): com.pulumi.aws.ses.ReceiptFilterArgs =
        com.pulumi.aws.ses.ReceiptFilterArgs.builder()
            .cidr(cidr?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReceiptFilterArgs].
 */
@PulumiTagMarker
public class ReceiptFilterArgsBuilder internal constructor() {
    private var cidr: Output<String>? = null

    private var name: Output<String>? = null

    private var policy: Output<String>? = null

    /**
     * @param value The IP address or address range to filter, in CIDR notation
     */
    @JvmName("fpsybtxfysfuvonu")
    public suspend fun cidr(`value`: Output<String>) {
        this.cidr = value
    }

    /**
     * @param value The name of the filter
     */
    @JvmName("kbfjyxlrmtvhyumk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Block or Allow
     */
    @JvmName("wffasbgrxmgxctmf")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The IP address or address range to filter, in CIDR notation
     */
    @JvmName("dmxqqpfdetoinnhu")
    public suspend fun cidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidr = mapped
    }

    /**
     * @param value The name of the filter
     */
    @JvmName("wkqhnitsealfnfqm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Block or Allow
     */
    @JvmName("peqrotnodsinmabd")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    internal fun build(): ReceiptFilterArgs = ReceiptFilterArgs(
        cidr = cidr,
        name = name,
        policy = policy,
    )
}
