@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin

import com.pulumi.aws.ses.kotlin.outputs.ReceiptRuleAddHeaderAction
import com.pulumi.aws.ses.kotlin.outputs.ReceiptRuleBounceAction
import com.pulumi.aws.ses.kotlin.outputs.ReceiptRuleLambdaAction
import com.pulumi.aws.ses.kotlin.outputs.ReceiptRuleS3Action
import com.pulumi.aws.ses.kotlin.outputs.ReceiptRuleSnsAction
import com.pulumi.aws.ses.kotlin.outputs.ReceiptRuleStopAction
import com.pulumi.aws.ses.kotlin.outputs.ReceiptRuleWorkmailAction
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.ses.kotlin.outputs.ReceiptRuleAddHeaderAction.Companion.toKotlin as receiptRuleAddHeaderActionToKotlin
import com.pulumi.aws.ses.kotlin.outputs.ReceiptRuleBounceAction.Companion.toKotlin as receiptRuleBounceActionToKotlin
import com.pulumi.aws.ses.kotlin.outputs.ReceiptRuleLambdaAction.Companion.toKotlin as receiptRuleLambdaActionToKotlin
import com.pulumi.aws.ses.kotlin.outputs.ReceiptRuleS3Action.Companion.toKotlin as receiptRuleS3ActionToKotlin
import com.pulumi.aws.ses.kotlin.outputs.ReceiptRuleSnsAction.Companion.toKotlin as receiptRuleSnsActionToKotlin
import com.pulumi.aws.ses.kotlin.outputs.ReceiptRuleStopAction.Companion.toKotlin as receiptRuleStopActionToKotlin
import com.pulumi.aws.ses.kotlin.outputs.ReceiptRuleWorkmailAction.Companion.toKotlin as receiptRuleWorkmailActionToKotlin

/**
 * Builder for [ReceiptRule].
 */
@PulumiTagMarker
public class ReceiptRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReceiptRuleArgs = ReceiptRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReceiptRuleArgsBuilder.() -> Unit) {
        val builder = ReceiptRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ReceiptRule {
        val builtJavaResource = com.pulumi.aws.ses.ReceiptRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ReceiptRule(builtJavaResource)
    }
}

/**
 * Provides an SES receipt rule resource
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.ReceiptRule;
 * import com.pulumi.aws.ses.ReceiptRuleArgs;
 * import com.pulumi.aws.ses.inputs.ReceiptRuleAddHeaderActionArgs;
 * import com.pulumi.aws.ses.inputs.ReceiptRuleS3ActionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var store = new ReceiptRule("store", ReceiptRuleArgs.builder()
 *             .addHeaderActions(ReceiptRuleAddHeaderActionArgs.builder()
 *                 .headerName("Custom-Header")
 *                 .headerValue("Added by SES")
 *                 .position(1)
 *                 .build())
 *             .enabled(true)
 *             .recipients("karen@example.com")
 *             .ruleSetName("default-rule-set")
 *             .s3Actions(ReceiptRuleS3ActionArgs.builder()
 *                 .bucketName("emails")
 *                 .position(2)
 *                 .build())
 *             .scanEnabled(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SES receipt rules using the ruleset name and rule name separated by `:`. For example:
 * ```sh
 *  $ pulumi import aws:ses/receiptRule:ReceiptRule my_rule my_rule_set:my_rule
 * ```
 *
 */
public class ReceiptRule internal constructor(
    override val javaResource: com.pulumi.aws.ses.ReceiptRule,
) : KotlinCustomResource(javaResource, ReceiptRuleMapper) {
    /**
     * A list of Add Header Action blocks. Documented below.
     */
    public val addHeaderActions: Output<List<ReceiptRuleAddHeaderAction>>?
        get() = javaResource.addHeaderActions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        receiptRuleAddHeaderActionToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The name of the rule to place this rule after
     */
    public val after: Output<String>?
        get() = javaResource.after().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The SES receipt rule ARN.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A list of Bounce Action blocks. Documented below.
     */
    public val bounceActions: Output<List<ReceiptRuleBounceAction>>?
        get() = javaResource.bounceActions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        receiptRuleBounceActionToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * If true, the rule will be enabled
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A list of Lambda Action blocks. Documented below.
     */
    public val lambdaActions: Output<List<ReceiptRuleLambdaAction>>?
        get() = javaResource.lambdaActions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        receiptRuleLambdaActionToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The name of the rule
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A list of email addresses
     */
    public val recipients: Output<List<String>>?
        get() = javaResource.recipients().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The name of the rule set
     */
    public val ruleSetName: Output<String>
        get() = javaResource.ruleSetName().applyValue({ args0 -> args0 })

    /**
     * A list of S3 Action blocks. Documented below.
     */
    public val s3Actions: Output<List<ReceiptRuleS3Action>>?
        get() = javaResource.s3Actions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> receiptRuleS3ActionToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * If true, incoming emails will be scanned for spam and viruses
     */
    public val scanEnabled: Output<Boolean>?
        get() = javaResource.scanEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A list of SNS Action blocks. Documented below.
     */
    public val snsActions: Output<List<ReceiptRuleSnsAction>>?
        get() = javaResource.snsActions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> receiptRuleSnsActionToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * A list of Stop Action blocks. Documented below.
     */
    public val stopActions: Output<List<ReceiptRuleStopAction>>?
        get() = javaResource.stopActions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> receiptRuleStopActionToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * `Require` or `Optional`
     */
    public val tlsPolicy: Output<String>
        get() = javaResource.tlsPolicy().applyValue({ args0 -> args0 })

    /**
     * A list of WorkMail Action blocks. Documented below.
     */
    public val workmailActions: Output<List<ReceiptRuleWorkmailAction>>?
        get() = javaResource.workmailActions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        receiptRuleWorkmailActionToKotlin(args0)
                    })
                })
            }).orElse(null)
        })
}

public object ReceiptRuleMapper : ResourceMapper<ReceiptRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ses.ReceiptRule::class == javaResource::class

    override fun map(javaResource: Resource): ReceiptRule = ReceiptRule(
        javaResource as
            com.pulumi.aws.ses.ReceiptRule,
    )
}

/**
 * @see [ReceiptRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ReceiptRule].
 */
public suspend fun receiptRule(name: String, block: suspend ReceiptRuleResourceBuilder.() -> Unit):
    ReceiptRule {
    val builder = ReceiptRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ReceiptRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun receiptRule(name: String): ReceiptRule {
    val builder = ReceiptRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
