@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin

import com.pulumi.aws.ses.ReceiptRuleArgs.builder
import com.pulumi.aws.ses.kotlin.inputs.ReceiptRuleAddHeaderActionArgs
import com.pulumi.aws.ses.kotlin.inputs.ReceiptRuleAddHeaderActionArgsBuilder
import com.pulumi.aws.ses.kotlin.inputs.ReceiptRuleBounceActionArgs
import com.pulumi.aws.ses.kotlin.inputs.ReceiptRuleBounceActionArgsBuilder
import com.pulumi.aws.ses.kotlin.inputs.ReceiptRuleLambdaActionArgs
import com.pulumi.aws.ses.kotlin.inputs.ReceiptRuleLambdaActionArgsBuilder
import com.pulumi.aws.ses.kotlin.inputs.ReceiptRuleS3ActionArgs
import com.pulumi.aws.ses.kotlin.inputs.ReceiptRuleS3ActionArgsBuilder
import com.pulumi.aws.ses.kotlin.inputs.ReceiptRuleSnsActionArgs
import com.pulumi.aws.ses.kotlin.inputs.ReceiptRuleSnsActionArgsBuilder
import com.pulumi.aws.ses.kotlin.inputs.ReceiptRuleStopActionArgs
import com.pulumi.aws.ses.kotlin.inputs.ReceiptRuleStopActionArgsBuilder
import com.pulumi.aws.ses.kotlin.inputs.ReceiptRuleWorkmailActionArgs
import com.pulumi.aws.ses.kotlin.inputs.ReceiptRuleWorkmailActionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an SES receipt rule resource
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.ReceiptRule;
 * import com.pulumi.aws.ses.ReceiptRuleArgs;
 * import com.pulumi.aws.ses.inputs.ReceiptRuleAddHeaderActionArgs;
 * import com.pulumi.aws.ses.inputs.ReceiptRuleS3ActionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var store = new ReceiptRule("store", ReceiptRuleArgs.builder()
 *             .addHeaderActions(ReceiptRuleAddHeaderActionArgs.builder()
 *                 .headerName("Custom-Header")
 *                 .headerValue("Added by SES")
 *                 .position(1)
 *                 .build())
 *             .enabled(true)
 *             .recipients("karen@example.com")
 *             .ruleSetName("default-rule-set")
 *             .s3Actions(ReceiptRuleS3ActionArgs.builder()
 *                 .bucketName("emails")
 *                 .position(2)
 *                 .build())
 *             .scanEnabled(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SES receipt rules using the ruleset name and rule name separated by `:`. For example:
 * ```sh
 *  $ pulumi import aws:ses/receiptRule:ReceiptRule my_rule my_rule_set:my_rule
 * ```
 * @property addHeaderActions A list of Add Header Action blocks. Documented below.
 * @property after The name of the rule to place this rule after
 * @property bounceActions A list of Bounce Action blocks. Documented below.
 * @property enabled If true, the rule will be enabled
 * @property lambdaActions A list of Lambda Action blocks. Documented below.
 * @property name The name of the rule
 * @property recipients A list of email addresses
 * @property ruleSetName The name of the rule set
 * @property s3Actions A list of S3 Action blocks. Documented below.
 * @property scanEnabled If true, incoming emails will be scanned for spam and viruses
 * @property snsActions A list of SNS Action blocks. Documented below.
 * @property stopActions A list of Stop Action blocks. Documented below.
 * @property tlsPolicy `Require` or `Optional`
 * @property workmailActions A list of WorkMail Action blocks. Documented below.
 */
public data class ReceiptRuleArgs(
    public val addHeaderActions: Output<List<ReceiptRuleAddHeaderActionArgs>>? = null,
    public val after: Output<String>? = null,
    public val bounceActions: Output<List<ReceiptRuleBounceActionArgs>>? = null,
    public val enabled: Output<Boolean>? = null,
    public val lambdaActions: Output<List<ReceiptRuleLambdaActionArgs>>? = null,
    public val name: Output<String>? = null,
    public val recipients: Output<List<String>>? = null,
    public val ruleSetName: Output<String>? = null,
    public val s3Actions: Output<List<ReceiptRuleS3ActionArgs>>? = null,
    public val scanEnabled: Output<Boolean>? = null,
    public val snsActions: Output<List<ReceiptRuleSnsActionArgs>>? = null,
    public val stopActions: Output<List<ReceiptRuleStopActionArgs>>? = null,
    public val tlsPolicy: Output<String>? = null,
    public val workmailActions: Output<List<ReceiptRuleWorkmailActionArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ses.ReceiptRuleArgs> {
    override fun toJava(): com.pulumi.aws.ses.ReceiptRuleArgs =
        com.pulumi.aws.ses.ReceiptRuleArgs.builder()
            .addHeaderActions(
                addHeaderActions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .after(after?.applyValue({ args0 -> args0 }))
            .bounceActions(
                bounceActions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .lambdaActions(
                lambdaActions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .recipients(recipients?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ruleSetName(ruleSetName?.applyValue({ args0 -> args0 }))
            .s3Actions(
                s3Actions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .scanEnabled(scanEnabled?.applyValue({ args0 -> args0 }))
            .snsActions(
                snsActions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .stopActions(
                stopActions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tlsPolicy(tlsPolicy?.applyValue({ args0 -> args0 }))
            .workmailActions(
                workmailActions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ReceiptRuleArgs].
 */
@PulumiTagMarker
public class ReceiptRuleArgsBuilder internal constructor() {
    private var addHeaderActions: Output<List<ReceiptRuleAddHeaderActionArgs>>? = null

    private var after: Output<String>? = null

    private var bounceActions: Output<List<ReceiptRuleBounceActionArgs>>? = null

    private var enabled: Output<Boolean>? = null

    private var lambdaActions: Output<List<ReceiptRuleLambdaActionArgs>>? = null

    private var name: Output<String>? = null

    private var recipients: Output<List<String>>? = null

    private var ruleSetName: Output<String>? = null

    private var s3Actions: Output<List<ReceiptRuleS3ActionArgs>>? = null

    private var scanEnabled: Output<Boolean>? = null

    private var snsActions: Output<List<ReceiptRuleSnsActionArgs>>? = null

    private var stopActions: Output<List<ReceiptRuleStopActionArgs>>? = null

    private var tlsPolicy: Output<String>? = null

    private var workmailActions: Output<List<ReceiptRuleWorkmailActionArgs>>? = null

    /**
     * @param value A list of Add Header Action blocks. Documented below.
     */
    @JvmName("xmskxprfvwjyialk")
    public suspend fun addHeaderActions(`value`: Output<List<ReceiptRuleAddHeaderActionArgs>>) {
        this.addHeaderActions = value
    }

    @JvmName("sbclntoqxufcwxws")
    public suspend fun addHeaderActions(vararg values: Output<ReceiptRuleAddHeaderActionArgs>) {
        this.addHeaderActions = Output.all(values.asList())
    }

    /**
     * @param values A list of Add Header Action blocks. Documented below.
     */
    @JvmName("xjahxmbgadfyjdeu")
    public suspend fun addHeaderActions(values: List<Output<ReceiptRuleAddHeaderActionArgs>>) {
        this.addHeaderActions = Output.all(values)
    }

    /**
     * @param value The name of the rule to place this rule after
     */
    @JvmName("mwgouhwuirmmcooj")
    public suspend fun after(`value`: Output<String>) {
        this.after = value
    }

    /**
     * @param value A list of Bounce Action blocks. Documented below.
     */
    @JvmName("ykkkajjhlmipgoii")
    public suspend fun bounceActions(`value`: Output<List<ReceiptRuleBounceActionArgs>>) {
        this.bounceActions = value
    }

    @JvmName("cqvbikwforalxnky")
    public suspend fun bounceActions(vararg values: Output<ReceiptRuleBounceActionArgs>) {
        this.bounceActions = Output.all(values.asList())
    }

    /**
     * @param values A list of Bounce Action blocks. Documented below.
     */
    @JvmName("fbvsiuvbkyywueyo")
    public suspend fun bounceActions(values: List<Output<ReceiptRuleBounceActionArgs>>) {
        this.bounceActions = Output.all(values)
    }

    /**
     * @param value If true, the rule will be enabled
     */
    @JvmName("lrtvryloqehvbgxk")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value A list of Lambda Action blocks. Documented below.
     */
    @JvmName("nnylkadtqkinowxf")
    public suspend fun lambdaActions(`value`: Output<List<ReceiptRuleLambdaActionArgs>>) {
        this.lambdaActions = value
    }

    @JvmName("miydqxbkqssviyvh")
    public suspend fun lambdaActions(vararg values: Output<ReceiptRuleLambdaActionArgs>) {
        this.lambdaActions = Output.all(values.asList())
    }

    /**
     * @param values A list of Lambda Action blocks. Documented below.
     */
    @JvmName("qwsdxtwwceevdxkj")
    public suspend fun lambdaActions(values: List<Output<ReceiptRuleLambdaActionArgs>>) {
        this.lambdaActions = Output.all(values)
    }

    /**
     * @param value The name of the rule
     */
    @JvmName("nroahhdmolhqsjgs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A list of email addresses
     */
    @JvmName("jydmmsbrxbwhcbxp")
    public suspend fun recipients(`value`: Output<List<String>>) {
        this.recipients = value
    }

    @JvmName("gqaqquammhkychvi")
    public suspend fun recipients(vararg values: Output<String>) {
        this.recipients = Output.all(values.asList())
    }

    /**
     * @param values A list of email addresses
     */
    @JvmName("stenvfrepvcuopqa")
    public suspend fun recipients(values: List<Output<String>>) {
        this.recipients = Output.all(values)
    }

    /**
     * @param value The name of the rule set
     */
    @JvmName("pkfmidrmhadhemei")
    public suspend fun ruleSetName(`value`: Output<String>) {
        this.ruleSetName = value
    }

    /**
     * @param value A list of S3 Action blocks. Documented below.
     */
    @JvmName("dqyeqqflktmywxul")
    public suspend fun s3Actions(`value`: Output<List<ReceiptRuleS3ActionArgs>>) {
        this.s3Actions = value
    }

    @JvmName("tsukynivlcfljequ")
    public suspend fun s3Actions(vararg values: Output<ReceiptRuleS3ActionArgs>) {
        this.s3Actions = Output.all(values.asList())
    }

    /**
     * @param values A list of S3 Action blocks. Documented below.
     */
    @JvmName("qwmacbqbuoplunqv")
    public suspend fun s3Actions(values: List<Output<ReceiptRuleS3ActionArgs>>) {
        this.s3Actions = Output.all(values)
    }

    /**
     * @param value If true, incoming emails will be scanned for spam and viruses
     */
    @JvmName("seuageekfflucsft")
    public suspend fun scanEnabled(`value`: Output<Boolean>) {
        this.scanEnabled = value
    }

    /**
     * @param value A list of SNS Action blocks. Documented below.
     */
    @JvmName("uyxvfygfswwdsdbw")
    public suspend fun snsActions(`value`: Output<List<ReceiptRuleSnsActionArgs>>) {
        this.snsActions = value
    }

    @JvmName("itgiggjwnnqcdgyu")
    public suspend fun snsActions(vararg values: Output<ReceiptRuleSnsActionArgs>) {
        this.snsActions = Output.all(values.asList())
    }

    /**
     * @param values A list of SNS Action blocks. Documented below.
     */
    @JvmName("iyqfxgimsxxdcqew")
    public suspend fun snsActions(values: List<Output<ReceiptRuleSnsActionArgs>>) {
        this.snsActions = Output.all(values)
    }

    /**
     * @param value A list of Stop Action blocks. Documented below.
     */
    @JvmName("rdybiawouiurcshq")
    public suspend fun stopActions(`value`: Output<List<ReceiptRuleStopActionArgs>>) {
        this.stopActions = value
    }

    @JvmName("byideimefbcgeiyj")
    public suspend fun stopActions(vararg values: Output<ReceiptRuleStopActionArgs>) {
        this.stopActions = Output.all(values.asList())
    }

    /**
     * @param values A list of Stop Action blocks. Documented below.
     */
    @JvmName("ohkyivcaxyfjiknu")
    public suspend fun stopActions(values: List<Output<ReceiptRuleStopActionArgs>>) {
        this.stopActions = Output.all(values)
    }

    /**
     * @param value `Require` or `Optional`
     */
    @JvmName("lsslagjmknotrwdf")
    public suspend fun tlsPolicy(`value`: Output<String>) {
        this.tlsPolicy = value
    }

    /**
     * @param value A list of WorkMail Action blocks. Documented below.
     */
    @JvmName("tifanlxrpmkpntuy")
    public suspend fun workmailActions(`value`: Output<List<ReceiptRuleWorkmailActionArgs>>) {
        this.workmailActions = value
    }

    @JvmName("lybmssdpcchwfkuk")
    public suspend fun workmailActions(vararg values: Output<ReceiptRuleWorkmailActionArgs>) {
        this.workmailActions = Output.all(values.asList())
    }

    /**
     * @param values A list of WorkMail Action blocks. Documented below.
     */
    @JvmName("tnbmfrcdjunjoywx")
    public suspend fun workmailActions(values: List<Output<ReceiptRuleWorkmailActionArgs>>) {
        this.workmailActions = Output.all(values)
    }

    /**
     * @param value A list of Add Header Action blocks. Documented below.
     */
    @JvmName("snqapuojgkdbennh")
    public suspend fun addHeaderActions(`value`: List<ReceiptRuleAddHeaderActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addHeaderActions = mapped
    }

    /**
     * @param argument A list of Add Header Action blocks. Documented below.
     */
    @JvmName("kbiqdkxnyycgrdgs")
    public suspend
    fun addHeaderActions(argument: List<suspend ReceiptRuleAddHeaderActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ReceiptRuleAddHeaderActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.addHeaderActions = mapped
    }

    /**
     * @param argument A list of Add Header Action blocks. Documented below.
     */
    @JvmName("ygjseyryhroxkvrr")
    public suspend fun addHeaderActions(
        vararg
        argument: suspend ReceiptRuleAddHeaderActionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ReceiptRuleAddHeaderActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.addHeaderActions = mapped
    }

    /**
     * @param argument A list of Add Header Action blocks. Documented below.
     */
    @JvmName("ajofljghhogwfntn")
    public suspend
    fun addHeaderActions(argument: suspend ReceiptRuleAddHeaderActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ReceiptRuleAddHeaderActionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.addHeaderActions = mapped
    }

    /**
     * @param values A list of Add Header Action blocks. Documented below.
     */
    @JvmName("pqjpfqmomujjjask")
    public suspend fun addHeaderActions(vararg values: ReceiptRuleAddHeaderActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addHeaderActions = mapped
    }

    /**
     * @param value The name of the rule to place this rule after
     */
    @JvmName("qxtaqnciwafpgudg")
    public suspend fun after(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.after = mapped
    }

    /**
     * @param value A list of Bounce Action blocks. Documented below.
     */
    @JvmName("yljjtwcklryeeehx")
    public suspend fun bounceActions(`value`: List<ReceiptRuleBounceActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bounceActions = mapped
    }

    /**
     * @param argument A list of Bounce Action blocks. Documented below.
     */
    @JvmName("tbttosfikimsyhla")
    public suspend
    fun bounceActions(argument: List<suspend ReceiptRuleBounceActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ReceiptRuleBounceActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.bounceActions = mapped
    }

    /**
     * @param argument A list of Bounce Action blocks. Documented below.
     */
    @JvmName("eirpewploqabutxt")
    public suspend fun bounceActions(
        vararg
        argument: suspend ReceiptRuleBounceActionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ReceiptRuleBounceActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.bounceActions = mapped
    }

    /**
     * @param argument A list of Bounce Action blocks. Documented below.
     */
    @JvmName("nvvncoqnhcejjolb")
    public suspend
    fun bounceActions(argument: suspend ReceiptRuleBounceActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ReceiptRuleBounceActionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.bounceActions = mapped
    }

    /**
     * @param values A list of Bounce Action blocks. Documented below.
     */
    @JvmName("ijlekkpvbhtvrars")
    public suspend fun bounceActions(vararg values: ReceiptRuleBounceActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bounceActions = mapped
    }

    /**
     * @param value If true, the rule will be enabled
     */
    @JvmName("yxjxsbpbxbsnrdko")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value A list of Lambda Action blocks. Documented below.
     */
    @JvmName("qhjxtxmewbhjtgbb")
    public suspend fun lambdaActions(`value`: List<ReceiptRuleLambdaActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lambdaActions = mapped
    }

    /**
     * @param argument A list of Lambda Action blocks. Documented below.
     */
    @JvmName("yuxyfdrkbqqmwyxx")
    public suspend
    fun lambdaActions(argument: List<suspend ReceiptRuleLambdaActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ReceiptRuleLambdaActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lambdaActions = mapped
    }

    /**
     * @param argument A list of Lambda Action blocks. Documented below.
     */
    @JvmName("khgsgvmluxygeapd")
    public suspend fun lambdaActions(
        vararg
        argument: suspend ReceiptRuleLambdaActionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ReceiptRuleLambdaActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lambdaActions = mapped
    }

    /**
     * @param argument A list of Lambda Action blocks. Documented below.
     */
    @JvmName("budwjmijpkduxkom")
    public suspend
    fun lambdaActions(argument: suspend ReceiptRuleLambdaActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ReceiptRuleLambdaActionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.lambdaActions = mapped
    }

    /**
     * @param values A list of Lambda Action blocks. Documented below.
     */
    @JvmName("wdqkeluvsaotytyd")
    public suspend fun lambdaActions(vararg values: ReceiptRuleLambdaActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lambdaActions = mapped
    }

    /**
     * @param value The name of the rule
     */
    @JvmName("wyqsnlropltrrjru")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A list of email addresses
     */
    @JvmName("aeokokwwcorestmf")
    public suspend fun recipients(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recipients = mapped
    }

    /**
     * @param values A list of email addresses
     */
    @JvmName("qoowvrveffirotqo")
    public suspend fun recipients(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recipients = mapped
    }

    /**
     * @param value The name of the rule set
     */
    @JvmName("vlewxjdwgbathdbp")
    public suspend fun ruleSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleSetName = mapped
    }

    /**
     * @param value A list of S3 Action blocks. Documented below.
     */
    @JvmName("gdffcffgjtrsmhwn")
    public suspend fun s3Actions(`value`: List<ReceiptRuleS3ActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Actions = mapped
    }

    /**
     * @param argument A list of S3 Action blocks. Documented below.
     */
    @JvmName("rlwpbxphpahxeisy")
    public suspend fun s3Actions(argument: List<suspend ReceiptRuleS3ActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ReceiptRuleS3ActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.s3Actions = mapped
    }

    /**
     * @param argument A list of S3 Action blocks. Documented below.
     */
    @JvmName("vdrvpadhqjtyutky")
    public suspend fun s3Actions(vararg argument: suspend ReceiptRuleS3ActionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ReceiptRuleS3ActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.s3Actions = mapped
    }

    /**
     * @param argument A list of S3 Action blocks. Documented below.
     */
    @JvmName("naqoeegwplaejfid")
    public suspend fun s3Actions(argument: suspend ReceiptRuleS3ActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ReceiptRuleS3ActionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.s3Actions = mapped
    }

    /**
     * @param values A list of S3 Action blocks. Documented below.
     */
    @JvmName("fpxknnnnybewunki")
    public suspend fun s3Actions(vararg values: ReceiptRuleS3ActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3Actions = mapped
    }

    /**
     * @param value If true, incoming emails will be scanned for spam and viruses
     */
    @JvmName("jvuwhdpqxwyioqhh")
    public suspend fun scanEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scanEnabled = mapped
    }

    /**
     * @param value A list of SNS Action blocks. Documented below.
     */
    @JvmName("hpibtlccmscgneda")
    public suspend fun snsActions(`value`: List<ReceiptRuleSnsActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snsActions = mapped
    }

    /**
     * @param argument A list of SNS Action blocks. Documented below.
     */
    @JvmName("ddcajsdljwrtjorx")
    public suspend
    fun snsActions(argument: List<suspend ReceiptRuleSnsActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ReceiptRuleSnsActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.snsActions = mapped
    }

    /**
     * @param argument A list of SNS Action blocks. Documented below.
     */
    @JvmName("ognjobeoeexqyduc")
    public suspend fun snsActions(
        vararg
        argument: suspend ReceiptRuleSnsActionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ReceiptRuleSnsActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.snsActions = mapped
    }

    /**
     * @param argument A list of SNS Action blocks. Documented below.
     */
    @JvmName("pbbxytupfumtlgsn")
    public suspend fun snsActions(argument: suspend ReceiptRuleSnsActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ReceiptRuleSnsActionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.snsActions = mapped
    }

    /**
     * @param values A list of SNS Action blocks. Documented below.
     */
    @JvmName("mxgbpbharjvdyyce")
    public suspend fun snsActions(vararg values: ReceiptRuleSnsActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.snsActions = mapped
    }

    /**
     * @param value A list of Stop Action blocks. Documented below.
     */
    @JvmName("awnggtmrbtxkgdrh")
    public suspend fun stopActions(`value`: List<ReceiptRuleStopActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stopActions = mapped
    }

    /**
     * @param argument A list of Stop Action blocks. Documented below.
     */
    @JvmName("nssagxpnvpflfxel")
    public suspend
    fun stopActions(argument: List<suspend ReceiptRuleStopActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ReceiptRuleStopActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.stopActions = mapped
    }

    /**
     * @param argument A list of Stop Action blocks. Documented below.
     */
    @JvmName("ddtumhnwbtjfeeqh")
    public suspend fun stopActions(
        vararg
        argument: suspend ReceiptRuleStopActionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ReceiptRuleStopActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.stopActions = mapped
    }

    /**
     * @param argument A list of Stop Action blocks. Documented below.
     */
    @JvmName("wchqoeixudcjyxaq")
    public suspend fun stopActions(argument: suspend ReceiptRuleStopActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ReceiptRuleStopActionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.stopActions = mapped
    }

    /**
     * @param values A list of Stop Action blocks. Documented below.
     */
    @JvmName("dmlqyvsipvogymxl")
    public suspend fun stopActions(vararg values: ReceiptRuleStopActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stopActions = mapped
    }

    /**
     * @param value `Require` or `Optional`
     */
    @JvmName("oouscyniwqfmrncj")
    public suspend fun tlsPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tlsPolicy = mapped
    }

    /**
     * @param value A list of WorkMail Action blocks. Documented below.
     */
    @JvmName("sfexfbyqukbddruo")
    public suspend fun workmailActions(`value`: List<ReceiptRuleWorkmailActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workmailActions = mapped
    }

    /**
     * @param argument A list of WorkMail Action blocks. Documented below.
     */
    @JvmName("annxcpwjpbkgdeyq")
    public suspend
    fun workmailActions(argument: List<suspend ReceiptRuleWorkmailActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ReceiptRuleWorkmailActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.workmailActions = mapped
    }

    /**
     * @param argument A list of WorkMail Action blocks. Documented below.
     */
    @JvmName("qggtqnywaccwobwe")
    public suspend fun workmailActions(
        vararg
        argument: suspend ReceiptRuleWorkmailActionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ReceiptRuleWorkmailActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.workmailActions = mapped
    }

    /**
     * @param argument A list of WorkMail Action blocks. Documented below.
     */
    @JvmName("pqpikaioskhpwcwk")
    public suspend
    fun workmailActions(argument: suspend ReceiptRuleWorkmailActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ReceiptRuleWorkmailActionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.workmailActions = mapped
    }

    /**
     * @param values A list of WorkMail Action blocks. Documented below.
     */
    @JvmName("gxagwcphvmfgdvqi")
    public suspend fun workmailActions(vararg values: ReceiptRuleWorkmailActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workmailActions = mapped
    }

    internal fun build(): ReceiptRuleArgs = ReceiptRuleArgs(
        addHeaderActions = addHeaderActions,
        after = after,
        bounceActions = bounceActions,
        enabled = enabled,
        lambdaActions = lambdaActions,
        name = name,
        recipients = recipients,
        ruleSetName = ruleSetName,
        s3Actions = s3Actions,
        scanEnabled = scanEnabled,
        snsActions = snsActions,
        stopActions = stopActions,
        tlsPolicy = tlsPolicy,
        workmailActions = workmailActions,
    )
}
