@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ReceiptRuleSet].
 */
@PulumiTagMarker
public class ReceiptRuleSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReceiptRuleSetArgs = ReceiptRuleSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReceiptRuleSetArgsBuilder.() -> Unit) {
        val builder = ReceiptRuleSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ReceiptRuleSet {
        val builtJavaResource = com.pulumi.aws.ses.ReceiptRuleSet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ReceiptRuleSet(builtJavaResource)
    }
}

/**
 * Provides an SES receipt rule set resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.ReceiptRuleSet;
 * import com.pulumi.aws.ses.ReceiptRuleSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new ReceiptRuleSet("main", ReceiptRuleSetArgs.builder()
 *             .ruleSetName("primary-rules")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SES receipt rule sets using the rule set name. For example:
 * ```sh
 *  $ pulumi import aws:ses/receiptRuleSet:ReceiptRuleSet my_rule_set my_rule_set_name
 * ```
 *
 */
public class ReceiptRuleSet internal constructor(
    override val javaResource: com.pulumi.aws.ses.ReceiptRuleSet,
) : KotlinCustomResource(javaResource, ReceiptRuleSetMapper) {
    /**
     * SES receipt rule set ARN.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Name of the rule set.
     */
    public val ruleSetName: Output<String>
        get() = javaResource.ruleSetName().applyValue({ args0 -> args0 })
}

public object ReceiptRuleSetMapper : ResourceMapper<ReceiptRuleSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ses.ReceiptRuleSet::class == javaResource::class

    override fun map(javaResource: Resource): ReceiptRuleSet = ReceiptRuleSet(
        javaResource as
            com.pulumi.aws.ses.ReceiptRuleSet,
    )
}

/**
 * @see [ReceiptRuleSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ReceiptRuleSet].
 */
public suspend fun receiptRuleSet(
    name: String,
    block: suspend ReceiptRuleSetResourceBuilder.() -> Unit,
): ReceiptRuleSet {
    val builder = ReceiptRuleSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ReceiptRuleSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun receiptRuleSet(name: String): ReceiptRuleSet {
    val builder = ReceiptRuleSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
