@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin

import com.pulumi.aws.ses.ReceiptRuleSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an SES receipt rule set resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.ReceiptRuleSet;
 * import com.pulumi.aws.ses.ReceiptRuleSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new ReceiptRuleSet("main", ReceiptRuleSetArgs.builder()
 *             .ruleSetName("primary-rules")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SES receipt rule sets using the rule set name. For example:
 * ```sh
 *  $ pulumi import aws:ses/receiptRuleSet:ReceiptRuleSet my_rule_set my_rule_set_name
 * ```
 * @property ruleSetName Name of the rule set.
 */
public data class ReceiptRuleSetArgs(
    public val ruleSetName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ses.ReceiptRuleSetArgs> {
    override fun toJava(): com.pulumi.aws.ses.ReceiptRuleSetArgs =
        com.pulumi.aws.ses.ReceiptRuleSetArgs.builder()
            .ruleSetName(ruleSetName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReceiptRuleSetArgs].
 */
@PulumiTagMarker
public class ReceiptRuleSetArgsBuilder internal constructor() {
    private var ruleSetName: Output<String>? = null

    /**
     * @param value Name of the rule set.
     */
    @JvmName("djwshescvuukvnpn")
    public suspend fun ruleSetName(`value`: Output<String>) {
        this.ruleSetName = value
    }

    /**
     * @param value Name of the rule set.
     */
    @JvmName("hkpcejnovgaifbcb")
    public suspend fun ruleSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleSetName = mapped
    }

    internal fun build(): ReceiptRuleSetArgs = ReceiptRuleSetArgs(
        ruleSetName = ruleSetName,
    )
}
