@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin.inputs

import com.pulumi.aws.ses.inputs.ConfigurationSetTrackingOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property customRedirectDomain Custom subdomain that is used to redirect email recipients to the Amazon SES event tracking domain.
 */
public data class ConfigurationSetTrackingOptionsArgs(
    public val customRedirectDomain: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ses.inputs.ConfigurationSetTrackingOptionsArgs> {
    override fun toJava(): com.pulumi.aws.ses.inputs.ConfigurationSetTrackingOptionsArgs =
        com.pulumi.aws.ses.inputs.ConfigurationSetTrackingOptionsArgs.builder()
            .customRedirectDomain(customRedirectDomain?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigurationSetTrackingOptionsArgs].
 */
@PulumiTagMarker
public class ConfigurationSetTrackingOptionsArgsBuilder internal constructor() {
    private var customRedirectDomain: Output<String>? = null

    /**
     * @param value Custom subdomain that is used to redirect email recipients to the Amazon SES event tracking domain.
     */
    @JvmName("bhjfwrxdkkxfmdvr")
    public suspend fun customRedirectDomain(`value`: Output<String>) {
        this.customRedirectDomain = value
    }

    /**
     * @param value Custom subdomain that is used to redirect email recipients to the Amazon SES event tracking domain.
     */
    @JvmName("neaftieqiojmdvck")
    public suspend fun customRedirectDomain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customRedirectDomain = mapped
    }

    internal fun build(): ConfigurationSetTrackingOptionsArgs = ConfigurationSetTrackingOptionsArgs(
        customRedirectDomain = customRedirectDomain,
    )
}
