@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin.inputs

import com.pulumi.aws.ses.inputs.EventDestinationSnsDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property topicArn The ARN of the SNS topic
 */
public data class EventDestinationSnsDestinationArgs(
    public val topicArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.ses.inputs.EventDestinationSnsDestinationArgs> {
    override fun toJava(): com.pulumi.aws.ses.inputs.EventDestinationSnsDestinationArgs =
        com.pulumi.aws.ses.inputs.EventDestinationSnsDestinationArgs.builder()
            .topicArn(topicArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventDestinationSnsDestinationArgs].
 */
@PulumiTagMarker
public class EventDestinationSnsDestinationArgsBuilder internal constructor() {
    private var topicArn: Output<String>? = null

    /**
     * @param value The ARN of the SNS topic
     */
    @JvmName("xrdnvdnmrcyhxjdx")
    public suspend fun topicArn(`value`: Output<String>) {
        this.topicArn = value
    }

    /**
     * @param value The ARN of the SNS topic
     */
    @JvmName("poasncpoxiiejdce")
    public suspend fun topicArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.topicArn = mapped
    }

    internal fun build(): EventDestinationSnsDestinationArgs = EventDestinationSnsDestinationArgs(
        topicArn = topicArn ?: throw PulumiNullFieldException("topicArn"),
    )
}
