@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin.inputs

import com.pulumi.aws.ses.inputs.GetDomainIdentityPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDomainIdentity.
 * @property domain Name of the domain
 */
public data class GetDomainIdentityPlainArgs(
    public val domain: String,
) : ConvertibleToJava<com.pulumi.aws.ses.inputs.GetDomainIdentityPlainArgs> {
    override fun toJava(): com.pulumi.aws.ses.inputs.GetDomainIdentityPlainArgs =
        com.pulumi.aws.ses.inputs.GetDomainIdentityPlainArgs.builder()
            .domain(domain.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDomainIdentityPlainArgs].
 */
@PulumiTagMarker
public class GetDomainIdentityPlainArgsBuilder internal constructor() {
    private var domain: String? = null

    /**
     * @param value Name of the domain
     */
    @JvmName("tjyalqquolcdukqk")
    public suspend fun domain(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.domain = mapped
    }

    internal fun build(): GetDomainIdentityPlainArgs = GetDomainIdentityPlainArgs(
        domain = domain ?: throw PulumiNullFieldException("domain"),
    )
}
