@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin.inputs

import com.pulumi.aws.ses.inputs.GetEmailIdentityPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEmailIdentity.
 * @property email Email identity.
 */
public data class GetEmailIdentityPlainArgs(
    public val email: String,
) : ConvertibleToJava<com.pulumi.aws.ses.inputs.GetEmailIdentityPlainArgs> {
    override fun toJava(): com.pulumi.aws.ses.inputs.GetEmailIdentityPlainArgs =
        com.pulumi.aws.ses.inputs.GetEmailIdentityPlainArgs.builder()
            .email(email.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEmailIdentityPlainArgs].
 */
@PulumiTagMarker
public class GetEmailIdentityPlainArgsBuilder internal constructor() {
    private var email: String? = null

    /**
     * @param value Email identity.
     */
    @JvmName("byulsyvxkdlrmjrf")
    public suspend fun email(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.email = mapped
    }

    internal fun build(): GetEmailIdentityPlainArgs = GetEmailIdentityPlainArgs(
        email = email ?: throw PulumiNullFieldException("email"),
    )
}
