@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin.inputs

import com.pulumi.aws.ses.inputs.ReceiptRuleAddHeaderActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property headerName The name of the header to add
 * @property headerValue The value of the header to add
 * @property position The position of the action in the receipt rule
 */
public data class ReceiptRuleAddHeaderActionArgs(
    public val headerName: Output<String>,
    public val headerValue: Output<String>,
    public val position: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.ses.inputs.ReceiptRuleAddHeaderActionArgs> {
    override fun toJava(): com.pulumi.aws.ses.inputs.ReceiptRuleAddHeaderActionArgs =
        com.pulumi.aws.ses.inputs.ReceiptRuleAddHeaderActionArgs.builder()
            .headerName(headerName.applyValue({ args0 -> args0 }))
            .headerValue(headerValue.applyValue({ args0 -> args0 }))
            .position(position.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReceiptRuleAddHeaderActionArgs].
 */
@PulumiTagMarker
public class ReceiptRuleAddHeaderActionArgsBuilder internal constructor() {
    private var headerName: Output<String>? = null

    private var headerValue: Output<String>? = null

    private var position: Output<Int>? = null

    /**
     * @param value The name of the header to add
     */
    @JvmName("vdthuoeikrvgwqaw")
    public suspend fun headerName(`value`: Output<String>) {
        this.headerName = value
    }

    /**
     * @param value The value of the header to add
     */
    @JvmName("fwmfddqdfkxnquji")
    public suspend fun headerValue(`value`: Output<String>) {
        this.headerValue = value
    }

    /**
     * @param value The position of the action in the receipt rule
     */
    @JvmName("jgedksgcxvmxqvkx")
    public suspend fun position(`value`: Output<Int>) {
        this.position = value
    }

    /**
     * @param value The name of the header to add
     */
    @JvmName("vkoqhvwjqfwbftra")
    public suspend fun headerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headerName = mapped
    }

    /**
     * @param value The value of the header to add
     */
    @JvmName("eogtrqqhjsiqgjlx")
    public suspend fun headerValue(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headerValue = mapped
    }

    /**
     * @param value The position of the action in the receipt rule
     */
    @JvmName("itujwovjhbtojxub")
    public suspend fun position(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.position = mapped
    }

    internal fun build(): ReceiptRuleAddHeaderActionArgs = ReceiptRuleAddHeaderActionArgs(
        headerName = headerName ?: throw PulumiNullFieldException("headerName"),
        headerValue = headerValue ?: throw PulumiNullFieldException("headerValue"),
        position = position ?: throw PulumiNullFieldException("position"),
    )
}
