@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin.inputs

import com.pulumi.aws.ses.inputs.ReceiptRuleBounceActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property message The message to send
 * @property position The position of the action in the receipt rule
 * @property sender The email address of the sender
 * @property smtpReplyCode The RFC 5321 SMTP reply code
 * @property statusCode The RFC 3463 SMTP enhanced status code
 * @property topicArn The ARN of an SNS topic to notify
 */
public data class ReceiptRuleBounceActionArgs(
    public val message: Output<String>,
    public val position: Output<Int>,
    public val sender: Output<String>,
    public val smtpReplyCode: Output<String>,
    public val statusCode: Output<String>? = null,
    public val topicArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ses.inputs.ReceiptRuleBounceActionArgs> {
    override fun toJava(): com.pulumi.aws.ses.inputs.ReceiptRuleBounceActionArgs =
        com.pulumi.aws.ses.inputs.ReceiptRuleBounceActionArgs.builder()
            .message(message.applyValue({ args0 -> args0 }))
            .position(position.applyValue({ args0 -> args0 }))
            .sender(sender.applyValue({ args0 -> args0 }))
            .smtpReplyCode(smtpReplyCode.applyValue({ args0 -> args0 }))
            .statusCode(statusCode?.applyValue({ args0 -> args0 }))
            .topicArn(topicArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReceiptRuleBounceActionArgs].
 */
@PulumiTagMarker
public class ReceiptRuleBounceActionArgsBuilder internal constructor() {
    private var message: Output<String>? = null

    private var position: Output<Int>? = null

    private var sender: Output<String>? = null

    private var smtpReplyCode: Output<String>? = null

    private var statusCode: Output<String>? = null

    private var topicArn: Output<String>? = null

    /**
     * @param value The message to send
     */
    @JvmName("gyyqvbcqaeisqwgg")
    public suspend fun message(`value`: Output<String>) {
        this.message = value
    }

    /**
     * @param value The position of the action in the receipt rule
     */
    @JvmName("etkgbkonbjsmtcfw")
    public suspend fun position(`value`: Output<Int>) {
        this.position = value
    }

    /**
     * @param value The email address of the sender
     */
    @JvmName("txmhlifntuhsebrv")
    public suspend fun sender(`value`: Output<String>) {
        this.sender = value
    }

    /**
     * @param value The RFC 5321 SMTP reply code
     */
    @JvmName("gmjhjlhrmxtngltv")
    public suspend fun smtpReplyCode(`value`: Output<String>) {
        this.smtpReplyCode = value
    }

    /**
     * @param value The RFC 3463 SMTP enhanced status code
     */
    @JvmName("sssrqyeeqjehnskl")
    public suspend fun statusCode(`value`: Output<String>) {
        this.statusCode = value
    }

    /**
     * @param value The ARN of an SNS topic to notify
     */
    @JvmName("tvoyvosbyogahjvt")
    public suspend fun topicArn(`value`: Output<String>) {
        this.topicArn = value
    }

    /**
     * @param value The message to send
     */
    @JvmName("cbvndldnffvlfdat")
    public suspend fun message(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.message = mapped
    }

    /**
     * @param value The position of the action in the receipt rule
     */
    @JvmName("dultenbttwretfli")
    public suspend fun position(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.position = mapped
    }

    /**
     * @param value The email address of the sender
     */
    @JvmName("xmxwbehvxlucgwnq")
    public suspend fun sender(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sender = mapped
    }

    /**
     * @param value The RFC 5321 SMTP reply code
     */
    @JvmName("yxskusuckgmgtdhr")
    public suspend fun smtpReplyCode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.smtpReplyCode = mapped
    }

    /**
     * @param value The RFC 3463 SMTP enhanced status code
     */
    @JvmName("fyqrcrewqihaverm")
    public suspend fun statusCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statusCode = mapped
    }

    /**
     * @param value The ARN of an SNS topic to notify
     */
    @JvmName("jeqyddhwkhloxkhi")
    public suspend fun topicArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topicArn = mapped
    }

    internal fun build(): ReceiptRuleBounceActionArgs = ReceiptRuleBounceActionArgs(
        message = message ?: throw PulumiNullFieldException("message"),
        position = position ?: throw PulumiNullFieldException("position"),
        sender = sender ?: throw PulumiNullFieldException("sender"),
        smtpReplyCode = smtpReplyCode ?: throw PulumiNullFieldException("smtpReplyCode"),
        statusCode = statusCode,
        topicArn = topicArn,
    )
}
