@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin.inputs

import com.pulumi.aws.ses.inputs.ReceiptRuleSnsActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property encoding The encoding to use for the email within the Amazon SNS notification. Default value is `UTF-8`.
 * @property position The position of the action in the receipt rule
 * @property topicArn The ARN of an SNS topic to notify
 */
public data class ReceiptRuleSnsActionArgs(
    public val encoding: Output<String>? = null,
    public val position: Output<Int>,
    public val topicArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.ses.inputs.ReceiptRuleSnsActionArgs> {
    override fun toJava(): com.pulumi.aws.ses.inputs.ReceiptRuleSnsActionArgs =
        com.pulumi.aws.ses.inputs.ReceiptRuleSnsActionArgs.builder()
            .encoding(encoding?.applyValue({ args0 -> args0 }))
            .position(position.applyValue({ args0 -> args0 }))
            .topicArn(topicArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReceiptRuleSnsActionArgs].
 */
@PulumiTagMarker
public class ReceiptRuleSnsActionArgsBuilder internal constructor() {
    private var encoding: Output<String>? = null

    private var position: Output<Int>? = null

    private var topicArn: Output<String>? = null

    /**
     * @param value The encoding to use for the email within the Amazon SNS notification. Default value is `UTF-8`.
     */
    @JvmName("ovsvhvayemvrogmv")
    public suspend fun encoding(`value`: Output<String>) {
        this.encoding = value
    }

    /**
     * @param value The position of the action in the receipt rule
     */
    @JvmName("bwisecvgqekdimdk")
    public suspend fun position(`value`: Output<Int>) {
        this.position = value
    }

    /**
     * @param value The ARN of an SNS topic to notify
     */
    @JvmName("usarusrkwvtugdrt")
    public suspend fun topicArn(`value`: Output<String>) {
        this.topicArn = value
    }

    /**
     * @param value The encoding to use for the email within the Amazon SNS notification. Default value is `UTF-8`.
     */
    @JvmName("bklusqallvgfibuj")
    public suspend fun encoding(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encoding = mapped
    }

    /**
     * @param value The position of the action in the receipt rule
     */
    @JvmName("arskatxrobiinxch")
    public suspend fun position(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.position = mapped
    }

    /**
     * @param value The ARN of an SNS topic to notify
     */
    @JvmName("auihnsuemkshfpcc")
    public suspend fun topicArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.topicArn = mapped
    }

    internal fun build(): ReceiptRuleSnsActionArgs = ReceiptRuleSnsActionArgs(
        encoding = encoding,
        position = position ?: throw PulumiNullFieldException("position"),
        topicArn = topicArn ?: throw PulumiNullFieldException("topicArn"),
    )
}
