@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin.inputs

import com.pulumi.aws.ses.inputs.ReceiptRuleWorkmailActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property organizationArn The ARN of the WorkMail organization
 * @property position The position of the action in the receipt rule
 * @property topicArn The ARN of an SNS topic to notify
 */
public data class ReceiptRuleWorkmailActionArgs(
    public val organizationArn: Output<String>,
    public val position: Output<Int>,
    public val topicArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ses.inputs.ReceiptRuleWorkmailActionArgs> {
    override fun toJava(): com.pulumi.aws.ses.inputs.ReceiptRuleWorkmailActionArgs =
        com.pulumi.aws.ses.inputs.ReceiptRuleWorkmailActionArgs.builder()
            .organizationArn(organizationArn.applyValue({ args0 -> args0 }))
            .position(position.applyValue({ args0 -> args0 }))
            .topicArn(topicArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReceiptRuleWorkmailActionArgs].
 */
@PulumiTagMarker
public class ReceiptRuleWorkmailActionArgsBuilder internal constructor() {
    private var organizationArn: Output<String>? = null

    private var position: Output<Int>? = null

    private var topicArn: Output<String>? = null

    /**
     * @param value The ARN of the WorkMail organization
     */
    @JvmName("vgouakgnygbfxoeh")
    public suspend fun organizationArn(`value`: Output<String>) {
        this.organizationArn = value
    }

    /**
     * @param value The position of the action in the receipt rule
     */
    @JvmName("tmuwowvllghigyio")
    public suspend fun position(`value`: Output<Int>) {
        this.position = value
    }

    /**
     * @param value The ARN of an SNS topic to notify
     */
    @JvmName("iypqaahecskoaxpc")
    public suspend fun topicArn(`value`: Output<String>) {
        this.topicArn = value
    }

    /**
     * @param value The ARN of the WorkMail organization
     */
    @JvmName("ljtcdllfwkpqefql")
    public suspend fun organizationArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.organizationArn = mapped
    }

    /**
     * @param value The position of the action in the receipt rule
     */
    @JvmName("uvcleiwynvsretyh")
    public suspend fun position(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.position = mapped
    }

    /**
     * @param value The ARN of an SNS topic to notify
     */
    @JvmName("pqrrytqvmoktpvfu")
    public suspend fun topicArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topicArn = mapped
    }

    internal fun build(): ReceiptRuleWorkmailActionArgs = ReceiptRuleWorkmailActionArgs(
        organizationArn = organizationArn ?: throw PulumiNullFieldException("organizationArn"),
        position = position ?: throw PulumiNullFieldException("position"),
        topicArn = topicArn,
    )
}
