@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property tlsPolicy Whether messages that use the configuration set are required to use Transport Layer Security (TLS). If the value is `Require`, messages are only delivered if a TLS connection can be established. If the value is `Optional`, messages can be delivered in plain text if a TLS connection can't be established. Valid values: `Require` or `Optional`. Defaults to `Optional`.
 */
public data class ConfigurationSetDeliveryOptions(
    public val tlsPolicy: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ses.outputs.ConfigurationSetDeliveryOptions):
            ConfigurationSetDeliveryOptions = ConfigurationSetDeliveryOptions(
            tlsPolicy = javaType.tlsPolicy().map({ args0 -> args0 }).orElse(null),
        )
    }
}
