@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property roleArn The ARN of the role that has permissions to access the Kinesis Stream
 * @property streamArn The ARN of the Kinesis Stream
 */
public data class EventDestinationKinesisDestination(
    public val roleArn: String,
    public val streamArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ses.outputs.EventDestinationKinesisDestination):
            EventDestinationKinesisDestination = EventDestinationKinesisDestination(
            roleArn = javaType.roleArn(),
            streamArn = javaType.streamArn(),
        )
    }
}
