@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getActiveReceiptRuleSet.
 * @property arn SES receipt rule set ARN.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ruleSetName Name of the rule set
 */
public data class GetActiveReceiptRuleSetResult(
    public val arn: String,
    public val id: String,
    public val ruleSetName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ses.outputs.GetActiveReceiptRuleSetResult):
            GetActiveReceiptRuleSetResult = GetActiveReceiptRuleSetResult(
            arn = javaType.arn(),
            id = javaType.id(),
            ruleSetName = javaType.ruleSetName(),
        )
    }
}
