@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getDomainIdentity.
 * @property arn ARN of the domain identity.
 * @property domain Name of the domain
 * @property id The provider-assigned unique ID for this managed resource.
 * @property verificationToken Code which when added to the domain as a TXT record will signal to SES that the owner of the domain has authorized SES to act on their behalf.
 */
public data class GetDomainIdentityResult(
    public val arn: String,
    public val domain: String,
    public val id: String,
    public val verificationToken: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ses.outputs.GetDomainIdentityResult):
            GetDomainIdentityResult = GetDomainIdentityResult(
            arn = javaType.arn(),
            domain = javaType.domain(),
            id = javaType.id(),
            verificationToken = javaType.verificationToken(),
        )
    }
}
