@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getEmailIdentity.
 * @property arn The ARN of the email identity.
 * @property email Email identity.
 * @property id The provider-assigned unique ID for this managed resource.
 */
public data class GetEmailIdentityResult(
    public val arn: String,
    public val email: String,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ses.outputs.GetEmailIdentityResult):
            GetEmailIdentityResult = GetEmailIdentityResult(
            arn = javaType.arn(),
            email = javaType.email(),
            id = javaType.id(),
        )
    }
}
