@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property message The message to send
 * @property position The position of the action in the receipt rule
 * @property sender The email address of the sender
 * @property smtpReplyCode The RFC 5321 SMTP reply code
 * @property statusCode The RFC 3463 SMTP enhanced status code
 * @property topicArn The ARN of an SNS topic to notify
 */
public data class ReceiptRuleBounceAction(
    public val message: String,
    public val position: Int,
    public val sender: String,
    public val smtpReplyCode: String,
    public val statusCode: String? = null,
    public val topicArn: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ses.outputs.ReceiptRuleBounceAction):
            ReceiptRuleBounceAction = ReceiptRuleBounceAction(
            message = javaType.message(),
            position = javaType.position(),
            sender = javaType.sender(),
            smtpReplyCode = javaType.smtpReplyCode(),
            statusCode = javaType.statusCode().map({ args0 -> args0 }).orElse(null),
            topicArn = javaType.topicArn().map({ args0 -> args0 }).orElse(null),
        )
    }
}
