@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property encoding The encoding to use for the email within the Amazon SNS notification. Default value is `UTF-8`.
 * @property position The position of the action in the receipt rule
 * @property topicArn The ARN of an SNS topic to notify
 */
public data class ReceiptRuleSnsAction(
    public val encoding: String? = null,
    public val position: Int,
    public val topicArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ses.outputs.ReceiptRuleSnsAction):
            ReceiptRuleSnsAction = ReceiptRuleSnsAction(
            encoding = javaType.encoding().map({ args0 -> args0 }).orElse(null),
            position = javaType.position(),
            topicArn = javaType.topicArn(),
        )
    }
}
