@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property position The position of the action in the receipt rule
 * @property scope The scope to apply. The only acceptable value is `RuleSet`.
 * @property topicArn The ARN of an SNS topic to notify
 */
public data class ReceiptRuleStopAction(
    public val position: Int,
    public val scope: String,
    public val topicArn: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ses.outputs.ReceiptRuleStopAction):
            ReceiptRuleStopAction = ReceiptRuleStopAction(
            position = javaType.position(),
            scope = javaType.scope(),
            topicArn = javaType.topicArn().map({ args0 -> args0 }).orElse(null),
        )
    }
}
