@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin

import com.pulumi.aws.sesv2.AccountVdmAttributesArgs.builder
import com.pulumi.aws.sesv2.kotlin.inputs.AccountVdmAttributesDashboardAttributesArgs
import com.pulumi.aws.sesv2.kotlin.inputs.AccountVdmAttributesDashboardAttributesArgsBuilder
import com.pulumi.aws.sesv2.kotlin.inputs.AccountVdmAttributesGuardianAttributesArgs
import com.pulumi.aws.sesv2.kotlin.inputs.AccountVdmAttributesGuardianAttributesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS SESv2 (Simple Email V2) Account VDM Attributes.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.AccountVdmAttributes;
 * import com.pulumi.aws.sesv2.AccountVdmAttributesArgs;
 * import com.pulumi.aws.sesv2.inputs.AccountVdmAttributesDashboardAttributesArgs;
 * import com.pulumi.aws.sesv2.inputs.AccountVdmAttributesGuardianAttributesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AccountVdmAttributes("example", AccountVdmAttributesArgs.builder()
 *             .dashboardAttributes(AccountVdmAttributesDashboardAttributesArgs.builder()
 *                 .engagementMetrics("ENABLED")
 *                 .build())
 *             .guardianAttributes(AccountVdmAttributesGuardianAttributesArgs.builder()
 *                 .optimizedSharedDelivery("ENABLED")
 *                 .build())
 *             .vdmEnabled("ENABLED")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SESv2 (Simple Email V2) Account VDM Attributes using the word `ses-account-vdm-attributes`. For example:
 * ```sh
 *  $ pulumi import aws:sesv2/accountVdmAttributes:AccountVdmAttributes example ses-account-vdm-attributes
 * ```
 * @property dashboardAttributes Specifies additional settings for your VDM configuration as applicable to the Dashboard.
 * @property guardianAttributes Specifies additional settings for your VDM configuration as applicable to the Guardian.
 * @property vdmEnabled Specifies the status of your VDM configuration. Valid values: `ENABLED`, `DISABLED`.
 * The following arguments are optional:
 */
public data class AccountVdmAttributesArgs(
    public val dashboardAttributes: Output<AccountVdmAttributesDashboardAttributesArgs>? = null,
    public val guardianAttributes: Output<AccountVdmAttributesGuardianAttributesArgs>? = null,
    public val vdmEnabled: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sesv2.AccountVdmAttributesArgs> {
    override fun toJava(): com.pulumi.aws.sesv2.AccountVdmAttributesArgs =
        com.pulumi.aws.sesv2.AccountVdmAttributesArgs.builder()
            .dashboardAttributes(
                dashboardAttributes?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .guardianAttributes(
                guardianAttributes?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .vdmEnabled(vdmEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccountVdmAttributesArgs].
 */
@PulumiTagMarker
public class AccountVdmAttributesArgsBuilder internal constructor() {
    private var dashboardAttributes: Output<AccountVdmAttributesDashboardAttributesArgs>? = null

    private var guardianAttributes: Output<AccountVdmAttributesGuardianAttributesArgs>? = null

    private var vdmEnabled: Output<String>? = null

    /**
     * @param value Specifies additional settings for your VDM configuration as applicable to the Dashboard.
     */
    @JvmName("xllsdmpaegbnxfbo")
    public suspend
    fun dashboardAttributes(`value`: Output<AccountVdmAttributesDashboardAttributesArgs>) {
        this.dashboardAttributes = value
    }

    /**
     * @param value Specifies additional settings for your VDM configuration as applicable to the Guardian.
     */
    @JvmName("myktadcniymcxudu")
    public suspend
    fun guardianAttributes(`value`: Output<AccountVdmAttributesGuardianAttributesArgs>) {
        this.guardianAttributes = value
    }

    /**
     * @param value Specifies the status of your VDM configuration. Valid values: `ENABLED`, `DISABLED`.
     * The following arguments are optional:
     */
    @JvmName("gauenvbugldmbssf")
    public suspend fun vdmEnabled(`value`: Output<String>) {
        this.vdmEnabled = value
    }

    /**
     * @param value Specifies additional settings for your VDM configuration as applicable to the Dashboard.
     */
    @JvmName("hdwrvoeiwglnhpkk")
    public suspend fun dashboardAttributes(`value`: AccountVdmAttributesDashboardAttributesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dashboardAttributes = mapped
    }

    /**
     * @param argument Specifies additional settings for your VDM configuration as applicable to the Dashboard.
     */
    @JvmName("lunivwsxaoiqvopt")
    public suspend
    fun dashboardAttributes(argument: suspend AccountVdmAttributesDashboardAttributesArgsBuilder.() -> Unit) {
        val toBeMapped = AccountVdmAttributesDashboardAttributesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dashboardAttributes = mapped
    }

    /**
     * @param value Specifies additional settings for your VDM configuration as applicable to the Guardian.
     */
    @JvmName("ospfcwwrhdcomujx")
    public suspend fun guardianAttributes(`value`: AccountVdmAttributesGuardianAttributesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.guardianAttributes = mapped
    }

    /**
     * @param argument Specifies additional settings for your VDM configuration as applicable to the Guardian.
     */
    @JvmName("tcqnofbfknplvygq")
    public suspend
    fun guardianAttributes(argument: suspend AccountVdmAttributesGuardianAttributesArgsBuilder.() -> Unit) {
        val toBeMapped = AccountVdmAttributesGuardianAttributesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.guardianAttributes = mapped
    }

    /**
     * @param value Specifies the status of your VDM configuration. Valid values: `ENABLED`, `DISABLED`.
     * The following arguments are optional:
     */
    @JvmName("cdxewacyilwkijnm")
    public suspend fun vdmEnabled(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vdmEnabled = mapped
    }

    internal fun build(): AccountVdmAttributesArgs = AccountVdmAttributesArgs(
        dashboardAttributes = dashboardAttributes,
        guardianAttributes = guardianAttributes,
        vdmEnabled = vdmEnabled,
    )
}
