@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin

import com.pulumi.aws.sesv2.ConfigurationSetArgs.builder
import com.pulumi.aws.sesv2.kotlin.inputs.ConfigurationSetDeliveryOptionsArgs
import com.pulumi.aws.sesv2.kotlin.inputs.ConfigurationSetDeliveryOptionsArgsBuilder
import com.pulumi.aws.sesv2.kotlin.inputs.ConfigurationSetReputationOptionsArgs
import com.pulumi.aws.sesv2.kotlin.inputs.ConfigurationSetReputationOptionsArgsBuilder
import com.pulumi.aws.sesv2.kotlin.inputs.ConfigurationSetSendingOptionsArgs
import com.pulumi.aws.sesv2.kotlin.inputs.ConfigurationSetSendingOptionsArgsBuilder
import com.pulumi.aws.sesv2.kotlin.inputs.ConfigurationSetSuppressionOptionsArgs
import com.pulumi.aws.sesv2.kotlin.inputs.ConfigurationSetSuppressionOptionsArgsBuilder
import com.pulumi.aws.sesv2.kotlin.inputs.ConfigurationSetTrackingOptionsArgs
import com.pulumi.aws.sesv2.kotlin.inputs.ConfigurationSetTrackingOptionsArgsBuilder
import com.pulumi.aws.sesv2.kotlin.inputs.ConfigurationSetVdmOptionsArgs
import com.pulumi.aws.sesv2.kotlin.inputs.ConfigurationSetVdmOptionsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS SESv2 (Simple Email V2) Configuration Set.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.ConfigurationSet;
 * import com.pulumi.aws.sesv2.ConfigurationSetArgs;
 * import com.pulumi.aws.sesv2.inputs.ConfigurationSetDeliveryOptionsArgs;
 * import com.pulumi.aws.sesv2.inputs.ConfigurationSetReputationOptionsArgs;
 * import com.pulumi.aws.sesv2.inputs.ConfigurationSetSendingOptionsArgs;
 * import com.pulumi.aws.sesv2.inputs.ConfigurationSetSuppressionOptionsArgs;
 * import com.pulumi.aws.sesv2.inputs.ConfigurationSetTrackingOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ConfigurationSet("example", ConfigurationSetArgs.builder()
 *             .configurationSetName("example")
 *             .deliveryOptions(ConfigurationSetDeliveryOptionsArgs.builder()
 *                 .tlsPolicy("REQUIRE")
 *                 .build())
 *             .reputationOptions(ConfigurationSetReputationOptionsArgs.builder()
 *                 .reputationMetricsEnabled(false)
 *                 .build())
 *             .sendingOptions(ConfigurationSetSendingOptionsArgs.builder()
 *                 .sendingEnabled(true)
 *                 .build())
 *             .suppressionOptions(ConfigurationSetSuppressionOptionsArgs.builder()
 *                 .suppressedReasons(
 *                     "BOUNCE",
 *                     "COMPLAINT")
 *                 .build())
 *             .trackingOptions(ConfigurationSetTrackingOptionsArgs.builder()
 *                 .customRedirectDomain("example.com")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SESv2 (Simple Email V2) Configuration Set using the `configuration_set_name`. For example:
 * ```sh
 *  $ pulumi import aws:sesv2/configurationSet:ConfigurationSet example example
 * ```
 * @property configurationSetName The name of the configuration set.
 * @property deliveryOptions An object that defines the dedicated IP pool that is used to send emails that you send using the configuration set.
 * @property reputationOptions An object that defines whether or not Amazon SES collects reputation metrics for the emails that you send that use the configuration set.
 * @property sendingOptions An object that defines whether or not Amazon SES can send email that you send using the configuration set.
 * @property suppressionOptions An object that contains information about the suppression list preferences for your account.
 * @property tags A map of tags to assign to the service. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property trackingOptions An object that defines the open and click tracking options for emails that you send using the configuration set.
 * @property vdmOptions An object that defines the VDM settings that apply to emails that you send using the configuration set.
 */
public data class ConfigurationSetArgs(
    public val configurationSetName: Output<String>? = null,
    public val deliveryOptions: Output<ConfigurationSetDeliveryOptionsArgs>? = null,
    public val reputationOptions: Output<ConfigurationSetReputationOptionsArgs>? = null,
    public val sendingOptions: Output<ConfigurationSetSendingOptionsArgs>? = null,
    public val suppressionOptions: Output<ConfigurationSetSuppressionOptionsArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val trackingOptions: Output<ConfigurationSetTrackingOptionsArgs>? = null,
    public val vdmOptions: Output<ConfigurationSetVdmOptionsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.sesv2.ConfigurationSetArgs> {
    override fun toJava(): com.pulumi.aws.sesv2.ConfigurationSetArgs =
        com.pulumi.aws.sesv2.ConfigurationSetArgs.builder()
            .configurationSetName(configurationSetName?.applyValue({ args0 -> args0 }))
            .deliveryOptions(deliveryOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .reputationOptions(reputationOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sendingOptions(sendingOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .suppressionOptions(
                suppressionOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .trackingOptions(trackingOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vdmOptions(vdmOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ConfigurationSetArgs].
 */
@PulumiTagMarker
public class ConfigurationSetArgsBuilder internal constructor() {
    private var configurationSetName: Output<String>? = null

    private var deliveryOptions: Output<ConfigurationSetDeliveryOptionsArgs>? = null

    private var reputationOptions: Output<ConfigurationSetReputationOptionsArgs>? = null

    private var sendingOptions: Output<ConfigurationSetSendingOptionsArgs>? = null

    private var suppressionOptions: Output<ConfigurationSetSuppressionOptionsArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var trackingOptions: Output<ConfigurationSetTrackingOptionsArgs>? = null

    private var vdmOptions: Output<ConfigurationSetVdmOptionsArgs>? = null

    /**
     * @param value The name of the configuration set.
     */
    @JvmName("gsbaeimloqjrntkn")
    public suspend fun configurationSetName(`value`: Output<String>) {
        this.configurationSetName = value
    }

    /**
     * @param value An object that defines the dedicated IP pool that is used to send emails that you send using the configuration set.
     */
    @JvmName("dxiyfnboicictqyf")
    public suspend fun deliveryOptions(`value`: Output<ConfigurationSetDeliveryOptionsArgs>) {
        this.deliveryOptions = value
    }

    /**
     * @param value An object that defines whether or not Amazon SES collects reputation metrics for the emails that you send that use the configuration set.
     */
    @JvmName("gllepurtrakgkqdw")
    public suspend fun reputationOptions(`value`: Output<ConfigurationSetReputationOptionsArgs>) {
        this.reputationOptions = value
    }

    /**
     * @param value An object that defines whether or not Amazon SES can send email that you send using the configuration set.
     */
    @JvmName("dxhlujdwpdvyrlje")
    public suspend fun sendingOptions(`value`: Output<ConfigurationSetSendingOptionsArgs>) {
        this.sendingOptions = value
    }

    /**
     * @param value An object that contains information about the suppression list preferences for your account.
     */
    @JvmName("xgynbopaagcxaiyu")
    public suspend fun suppressionOptions(`value`: Output<ConfigurationSetSuppressionOptionsArgs>) {
        this.suppressionOptions = value
    }

    /**
     * @param value A map of tags to assign to the service. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rbryybmsonynyoqg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value An object that defines the open and click tracking options for emails that you send using the configuration set.
     */
    @JvmName("dulhudkcrjulshtn")
    public suspend fun trackingOptions(`value`: Output<ConfigurationSetTrackingOptionsArgs>) {
        this.trackingOptions = value
    }

    /**
     * @param value An object that defines the VDM settings that apply to emails that you send using the configuration set.
     */
    @JvmName("gvsscvirjfwwgpmw")
    public suspend fun vdmOptions(`value`: Output<ConfigurationSetVdmOptionsArgs>) {
        this.vdmOptions = value
    }

    /**
     * @param value The name of the configuration set.
     */
    @JvmName("svblvwhtyroxcigp")
    public suspend fun configurationSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationSetName = mapped
    }

    /**
     * @param value An object that defines the dedicated IP pool that is used to send emails that you send using the configuration set.
     */
    @JvmName("clcgkmglkwaxpmtq")
    public suspend fun deliveryOptions(`value`: ConfigurationSetDeliveryOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryOptions = mapped
    }

    /**
     * @param argument An object that defines the dedicated IP pool that is used to send emails that you send using the configuration set.
     */
    @JvmName("cxdqvnyrfpfubako")
    public suspend
    fun deliveryOptions(argument: suspend ConfigurationSetDeliveryOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = ConfigurationSetDeliveryOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deliveryOptions = mapped
    }

    /**
     * @param value An object that defines whether or not Amazon SES collects reputation metrics for the emails that you send that use the configuration set.
     */
    @JvmName("huyengixfkqxitrt")
    public suspend fun reputationOptions(`value`: ConfigurationSetReputationOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reputationOptions = mapped
    }

    /**
     * @param argument An object that defines whether or not Amazon SES collects reputation metrics for the emails that you send that use the configuration set.
     */
    @JvmName("atvoarqknsgkibih")
    public suspend
    fun reputationOptions(argument: suspend ConfigurationSetReputationOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = ConfigurationSetReputationOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.reputationOptions = mapped
    }

    /**
     * @param value An object that defines whether or not Amazon SES can send email that you send using the configuration set.
     */
    @JvmName("qqifkabkuonerohp")
    public suspend fun sendingOptions(`value`: ConfigurationSetSendingOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sendingOptions = mapped
    }

    /**
     * @param argument An object that defines whether or not Amazon SES can send email that you send using the configuration set.
     */
    @JvmName("vmrxejkhpwcoexqb")
    public suspend
    fun sendingOptions(argument: suspend ConfigurationSetSendingOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = ConfigurationSetSendingOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sendingOptions = mapped
    }

    /**
     * @param value An object that contains information about the suppression list preferences for your account.
     */
    @JvmName("bejusxsvmrgmyucd")
    public suspend fun suppressionOptions(`value`: ConfigurationSetSuppressionOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.suppressionOptions = mapped
    }

    /**
     * @param argument An object that contains information about the suppression list preferences for your account.
     */
    @JvmName("uxlfswwksqshpjyc")
    public suspend
    fun suppressionOptions(argument: suspend ConfigurationSetSuppressionOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = ConfigurationSetSuppressionOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.suppressionOptions = mapped
    }

    /**
     * @param value A map of tags to assign to the service. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mubdkfhjerosfful")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the service. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xxtuvujfuxpreqdt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value An object that defines the open and click tracking options for emails that you send using the configuration set.
     */
    @JvmName("dmnsvkrmspygrnpx")
    public suspend fun trackingOptions(`value`: ConfigurationSetTrackingOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trackingOptions = mapped
    }

    /**
     * @param argument An object that defines the open and click tracking options for emails that you send using the configuration set.
     */
    @JvmName("fbqhudlsoreeisln")
    public suspend
    fun trackingOptions(argument: suspend ConfigurationSetTrackingOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = ConfigurationSetTrackingOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.trackingOptions = mapped
    }

    /**
     * @param value An object that defines the VDM settings that apply to emails that you send using the configuration set.
     */
    @JvmName("prvyxmrbyxvepqyc")
    public suspend fun vdmOptions(`value`: ConfigurationSetVdmOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vdmOptions = mapped
    }

    /**
     * @param argument An object that defines the VDM settings that apply to emails that you send using the configuration set.
     */
    @JvmName("onmynhjvbptvrppv")
    public suspend
    fun vdmOptions(argument: suspend ConfigurationSetVdmOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = ConfigurationSetVdmOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vdmOptions = mapped
    }

    internal fun build(): ConfigurationSetArgs = ConfigurationSetArgs(
        configurationSetName = configurationSetName,
        deliveryOptions = deliveryOptions,
        reputationOptions = reputationOptions,
        sendingOptions = sendingOptions,
        suppressionOptions = suppressionOptions,
        tags = tags,
        trackingOptions = trackingOptions,
        vdmOptions = vdmOptions,
    )
}
