@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin

import com.pulumi.aws.sesv2.kotlin.outputs.ConfigurationSetEventDestinationEventDestination
import com.pulumi.aws.sesv2.kotlin.outputs.ConfigurationSetEventDestinationEventDestination.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ConfigurationSetEventDestination].
 */
@PulumiTagMarker
public class ConfigurationSetEventDestinationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConfigurationSetEventDestinationArgs = ConfigurationSetEventDestinationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConfigurationSetEventDestinationArgsBuilder.() -> Unit) {
        val builder = ConfigurationSetEventDestinationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ConfigurationSetEventDestination {
        val builtJavaResource =
            com.pulumi.aws.sesv2.ConfigurationSetEventDestination(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ConfigurationSetEventDestination(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS SESv2 (Simple Email V2) Configuration Set Event Destination.
 * ## Example Usage
 * ### Cloud Watch Destination
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.ConfigurationSet;
 * import com.pulumi.aws.sesv2.ConfigurationSetArgs;
 * import com.pulumi.aws.sesv2.ConfigurationSetEventDestination;
 * import com.pulumi.aws.sesv2.ConfigurationSetEventDestinationArgs;
 * import com.pulumi.aws.sesv2.inputs.ConfigurationSetEventDestinationEventDestinationArgs;
 * import com.pulumi.aws.sesv2.inputs.ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleConfigurationSet = new ConfigurationSet("exampleConfigurationSet", ConfigurationSetArgs.builder()
 *             .configurationSetName("example")
 *             .build());
 *         var exampleConfigurationSetEventDestination = new ConfigurationSetEventDestination("exampleConfigurationSetEventDestination", ConfigurationSetEventDestinationArgs.builder()
 *             .configurationSetName(exampleConfigurationSet.configurationSetName())
 *             .eventDestinationName("example")
 *             .eventDestination(ConfigurationSetEventDestinationEventDestinationArgs.builder()
 *                 .cloudWatchDestination(ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationArgs.builder()
 *                     .dimensionConfigurations(ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationDimensionConfigurationArgs.builder()
 *                         .defaultDimensionValue("example")
 *                         .dimensionName("example")
 *                         .dimensionValueSource("MESSAGE_TAG")
 *                         .build())
 *                     .build())
 *                 .enabled(true)
 *                 .matchingEventTypes("SEND")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Kinesis Firehose Destination
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.ConfigurationSet;
 * import com.pulumi.aws.sesv2.ConfigurationSetArgs;
 * import com.pulumi.aws.sesv2.ConfigurationSetEventDestination;
 * import com.pulumi.aws.sesv2.ConfigurationSetEventDestinationArgs;
 * import com.pulumi.aws.sesv2.inputs.ConfigurationSetEventDestinationEventDestinationArgs;
 * import com.pulumi.aws.sesv2.inputs.ConfigurationSetEventDestinationEventDestinationKinesisFirehoseDestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleConfigurationSet = new ConfigurationSet("exampleConfigurationSet", ConfigurationSetArgs.builder()
 *             .configurationSetName("example")
 *             .build());
 *         var exampleConfigurationSetEventDestination = new ConfigurationSetEventDestination("exampleConfigurationSetEventDestination", ConfigurationSetEventDestinationArgs.builder()
 *             .configurationSetName(exampleConfigurationSet.configurationSetName())
 *             .eventDestinationName("example")
 *             .eventDestination(ConfigurationSetEventDestinationEventDestinationArgs.builder()
 *                 .kinesisFirehoseDestination(ConfigurationSetEventDestinationEventDestinationKinesisFirehoseDestinationArgs.builder()
 *                     .deliveryStreamArn(aws_kinesis_firehose_delivery_stream.example().arn())
 *                     .iamRoleArn(aws_iam_role.example().arn())
 *                     .build())
 *                 .enabled(true)
 *                 .matchingEventTypes("SEND")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Pinpoint Destination
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.ConfigurationSet;
 * import com.pulumi.aws.sesv2.ConfigurationSetArgs;
 * import com.pulumi.aws.sesv2.ConfigurationSetEventDestination;
 * import com.pulumi.aws.sesv2.ConfigurationSetEventDestinationArgs;
 * import com.pulumi.aws.sesv2.inputs.ConfigurationSetEventDestinationEventDestinationArgs;
 * import com.pulumi.aws.sesv2.inputs.ConfigurationSetEventDestinationEventDestinationPinpointDestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleConfigurationSet = new ConfigurationSet("exampleConfigurationSet", ConfigurationSetArgs.builder()
 *             .configurationSetName("example")
 *             .build());
 *         var exampleConfigurationSetEventDestination = new ConfigurationSetEventDestination("exampleConfigurationSetEventDestination", ConfigurationSetEventDestinationArgs.builder()
 *             .configurationSetName(exampleConfigurationSet.configurationSetName())
 *             .eventDestinationName("example")
 *             .eventDestination(ConfigurationSetEventDestinationEventDestinationArgs.builder()
 *                 .pinpointDestination(ConfigurationSetEventDestinationEventDestinationPinpointDestinationArgs.builder()
 *                     .applicationArn(aws_pinpoint_app.example().arn())
 *                     .build())
 *                 .enabled(true)
 *                 .matchingEventTypes("SEND")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### SNS Destination
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.ConfigurationSet;
 * import com.pulumi.aws.sesv2.ConfigurationSetArgs;
 * import com.pulumi.aws.sesv2.ConfigurationSetEventDestination;
 * import com.pulumi.aws.sesv2.ConfigurationSetEventDestinationArgs;
 * import com.pulumi.aws.sesv2.inputs.ConfigurationSetEventDestinationEventDestinationArgs;
 * import com.pulumi.aws.sesv2.inputs.ConfigurationSetEventDestinationEventDestinationSnsDestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleConfigurationSet = new ConfigurationSet("exampleConfigurationSet", ConfigurationSetArgs.builder()
 *             .configurationSetName("example")
 *             .build());
 *         var exampleConfigurationSetEventDestination = new ConfigurationSetEventDestination("exampleConfigurationSetEventDestination", ConfigurationSetEventDestinationArgs.builder()
 *             .configurationSetName(exampleConfigurationSet.configurationSetName())
 *             .eventDestinationName("example")
 *             .eventDestination(ConfigurationSetEventDestinationEventDestinationArgs.builder()
 *                 .snsDestination(ConfigurationSetEventDestinationEventDestinationSnsDestinationArgs.builder()
 *                     .topicArn(aws_sns_topic.example().arn())
 *                     .build())
 *                 .enabled(true)
 *                 .matchingEventTypes("SEND")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SESv2 (Simple Email V2) Configuration Set Event Destination using the `id` (`configuration_set_name|event_destination_name`). For example:
 * ```sh
 *  $ pulumi import aws:sesv2/configurationSetEventDestination:ConfigurationSetEventDestination example example_configuration_set|example_event_destination
 * ```
 *
 */
public class ConfigurationSetEventDestination internal constructor(
    override val javaResource: com.pulumi.aws.sesv2.ConfigurationSetEventDestination,
) : KotlinCustomResource(javaResource, ConfigurationSetEventDestinationMapper) {
    /**
     * The name of the configuration set.
     */
    public val configurationSetName: Output<String>
        get() = javaResource.configurationSetName().applyValue({ args0 -> args0 })

    /**
     * A name that identifies the event destination within the configuration set.
     */
    public val eventDestination: Output<ConfigurationSetEventDestinationEventDestination>
        get() = javaResource.eventDestination().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * An object that defines the event destination. See event_destination below.
     */
    public val eventDestinationName: Output<String>
        get() = javaResource.eventDestinationName().applyValue({ args0 -> args0 })
}

public object ConfigurationSetEventDestinationMapper :
    ResourceMapper<ConfigurationSetEventDestination> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sesv2.ConfigurationSetEventDestination::class == javaResource::class

    override fun map(javaResource: Resource): ConfigurationSetEventDestination =
        ConfigurationSetEventDestination(
            javaResource as
                com.pulumi.aws.sesv2.ConfigurationSetEventDestination,
        )
}

/**
 * @see [ConfigurationSetEventDestination].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConfigurationSetEventDestination].
 */
public suspend fun configurationSetEventDestination(
    name: String,
    block: suspend ConfigurationSetEventDestinationResourceBuilder.() -> Unit,
):
    ConfigurationSetEventDestination {
    val builder = ConfigurationSetEventDestinationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConfigurationSetEventDestination].
 * @param name The _unique_ name of the resulting resource.
 */
public fun configurationSetEventDestination(name: String): ConfigurationSetEventDestination {
    val builder = ConfigurationSetEventDestinationResourceBuilder()
    builder.name(name)
    return builder.build()
}
