@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin

import com.pulumi.aws.sesv2.ConfigurationSetEventDestinationArgs.builder
import com.pulumi.aws.sesv2.kotlin.inputs.ConfigurationSetEventDestinationEventDestinationArgs
import com.pulumi.aws.sesv2.kotlin.inputs.ConfigurationSetEventDestinationEventDestinationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS SESv2 (Simple Email V2) Configuration Set Event Destination.
 * ## Example Usage
 * ### Cloud Watch Destination
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.ConfigurationSet;
 * import com.pulumi.aws.sesv2.ConfigurationSetArgs;
 * import com.pulumi.aws.sesv2.ConfigurationSetEventDestination;
 * import com.pulumi.aws.sesv2.ConfigurationSetEventDestinationArgs;
 * import com.pulumi.aws.sesv2.inputs.ConfigurationSetEventDestinationEventDestinationArgs;
 * import com.pulumi.aws.sesv2.inputs.ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleConfigurationSet = new ConfigurationSet("exampleConfigurationSet", ConfigurationSetArgs.builder()
 *             .configurationSetName("example")
 *             .build());
 *         var exampleConfigurationSetEventDestination = new ConfigurationSetEventDestination("exampleConfigurationSetEventDestination", ConfigurationSetEventDestinationArgs.builder()
 *             .configurationSetName(exampleConfigurationSet.configurationSetName())
 *             .eventDestinationName("example")
 *             .eventDestination(ConfigurationSetEventDestinationEventDestinationArgs.builder()
 *                 .cloudWatchDestination(ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationArgs.builder()
 *                     .dimensionConfigurations(ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationDimensionConfigurationArgs.builder()
 *                         .defaultDimensionValue("example")
 *                         .dimensionName("example")
 *                         .dimensionValueSource("MESSAGE_TAG")
 *                         .build())
 *                     .build())
 *                 .enabled(true)
 *                 .matchingEventTypes("SEND")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Kinesis Firehose Destination
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.ConfigurationSet;
 * import com.pulumi.aws.sesv2.ConfigurationSetArgs;
 * import com.pulumi.aws.sesv2.ConfigurationSetEventDestination;
 * import com.pulumi.aws.sesv2.ConfigurationSetEventDestinationArgs;
 * import com.pulumi.aws.sesv2.inputs.ConfigurationSetEventDestinationEventDestinationArgs;
 * import com.pulumi.aws.sesv2.inputs.ConfigurationSetEventDestinationEventDestinationKinesisFirehoseDestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleConfigurationSet = new ConfigurationSet("exampleConfigurationSet", ConfigurationSetArgs.builder()
 *             .configurationSetName("example")
 *             .build());
 *         var exampleConfigurationSetEventDestination = new ConfigurationSetEventDestination("exampleConfigurationSetEventDestination", ConfigurationSetEventDestinationArgs.builder()
 *             .configurationSetName(exampleConfigurationSet.configurationSetName())
 *             .eventDestinationName("example")
 *             .eventDestination(ConfigurationSetEventDestinationEventDestinationArgs.builder()
 *                 .kinesisFirehoseDestination(ConfigurationSetEventDestinationEventDestinationKinesisFirehoseDestinationArgs.builder()
 *                     .deliveryStreamArn(aws_kinesis_firehose_delivery_stream.example().arn())
 *                     .iamRoleArn(aws_iam_role.example().arn())
 *                     .build())
 *                 .enabled(true)
 *                 .matchingEventTypes("SEND")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Pinpoint Destination
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.ConfigurationSet;
 * import com.pulumi.aws.sesv2.ConfigurationSetArgs;
 * import com.pulumi.aws.sesv2.ConfigurationSetEventDestination;
 * import com.pulumi.aws.sesv2.ConfigurationSetEventDestinationArgs;
 * import com.pulumi.aws.sesv2.inputs.ConfigurationSetEventDestinationEventDestinationArgs;
 * import com.pulumi.aws.sesv2.inputs.ConfigurationSetEventDestinationEventDestinationPinpointDestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleConfigurationSet = new ConfigurationSet("exampleConfigurationSet", ConfigurationSetArgs.builder()
 *             .configurationSetName("example")
 *             .build());
 *         var exampleConfigurationSetEventDestination = new ConfigurationSetEventDestination("exampleConfigurationSetEventDestination", ConfigurationSetEventDestinationArgs.builder()
 *             .configurationSetName(exampleConfigurationSet.configurationSetName())
 *             .eventDestinationName("example")
 *             .eventDestination(ConfigurationSetEventDestinationEventDestinationArgs.builder()
 *                 .pinpointDestination(ConfigurationSetEventDestinationEventDestinationPinpointDestinationArgs.builder()
 *                     .applicationArn(aws_pinpoint_app.example().arn())
 *                     .build())
 *                 .enabled(true)
 *                 .matchingEventTypes("SEND")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### SNS Destination
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.ConfigurationSet;
 * import com.pulumi.aws.sesv2.ConfigurationSetArgs;
 * import com.pulumi.aws.sesv2.ConfigurationSetEventDestination;
 * import com.pulumi.aws.sesv2.ConfigurationSetEventDestinationArgs;
 * import com.pulumi.aws.sesv2.inputs.ConfigurationSetEventDestinationEventDestinationArgs;
 * import com.pulumi.aws.sesv2.inputs.ConfigurationSetEventDestinationEventDestinationSnsDestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleConfigurationSet = new ConfigurationSet("exampleConfigurationSet", ConfigurationSetArgs.builder()
 *             .configurationSetName("example")
 *             .build());
 *         var exampleConfigurationSetEventDestination = new ConfigurationSetEventDestination("exampleConfigurationSetEventDestination", ConfigurationSetEventDestinationArgs.builder()
 *             .configurationSetName(exampleConfigurationSet.configurationSetName())
 *             .eventDestinationName("example")
 *             .eventDestination(ConfigurationSetEventDestinationEventDestinationArgs.builder()
 *                 .snsDestination(ConfigurationSetEventDestinationEventDestinationSnsDestinationArgs.builder()
 *                     .topicArn(aws_sns_topic.example().arn())
 *                     .build())
 *                 .enabled(true)
 *                 .matchingEventTypes("SEND")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SESv2 (Simple Email V2) Configuration Set Event Destination using the `id` (`configuration_set_name|event_destination_name`). For example:
 * ```sh
 *  $ pulumi import aws:sesv2/configurationSetEventDestination:ConfigurationSetEventDestination example example_configuration_set|example_event_destination
 * ```
 * @property configurationSetName The name of the configuration set.
 * @property eventDestination A name that identifies the event destination within the configuration set.
 * @property eventDestinationName An object that defines the event destination. See event_destination below.
 */
public data class ConfigurationSetEventDestinationArgs(
    public val configurationSetName: Output<String>? = null,
    public val eventDestination: Output<ConfigurationSetEventDestinationEventDestinationArgs>? = null,
    public val eventDestinationName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sesv2.ConfigurationSetEventDestinationArgs> {
    override fun toJava(): com.pulumi.aws.sesv2.ConfigurationSetEventDestinationArgs =
        com.pulumi.aws.sesv2.ConfigurationSetEventDestinationArgs.builder()
            .configurationSetName(configurationSetName?.applyValue({ args0 -> args0 }))
            .eventDestination(eventDestination?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .eventDestinationName(eventDestinationName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigurationSetEventDestinationArgs].
 */
@PulumiTagMarker
public class ConfigurationSetEventDestinationArgsBuilder internal constructor() {
    private var configurationSetName: Output<String>? = null

    private var eventDestination: Output<ConfigurationSetEventDestinationEventDestinationArgs>? = null

    private var eventDestinationName: Output<String>? = null

    /**
     * @param value The name of the configuration set.
     */
    @JvmName("uquapevygkeqxgbt")
    public suspend fun configurationSetName(`value`: Output<String>) {
        this.configurationSetName = value
    }

    /**
     * @param value A name that identifies the event destination within the configuration set.
     */
    @JvmName("nnpadddxmbykfgyj")
    public suspend
    fun eventDestination(`value`: Output<ConfigurationSetEventDestinationEventDestinationArgs>) {
        this.eventDestination = value
    }

    /**
     * @param value An object that defines the event destination. See event_destination below.
     */
    @JvmName("fcvesvvafuevmxmo")
    public suspend fun eventDestinationName(`value`: Output<String>) {
        this.eventDestinationName = value
    }

    /**
     * @param value The name of the configuration set.
     */
    @JvmName("uhdmkcakoovfngct")
    public suspend fun configurationSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationSetName = mapped
    }

    /**
     * @param value A name that identifies the event destination within the configuration set.
     */
    @JvmName("drhqiwucyriqbwuk")
    public suspend
    fun eventDestination(`value`: ConfigurationSetEventDestinationEventDestinationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventDestination = mapped
    }

    /**
     * @param argument A name that identifies the event destination within the configuration set.
     */
    @JvmName("hfnnautddoejnhry")
    public suspend
    fun eventDestination(argument: suspend ConfigurationSetEventDestinationEventDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = ConfigurationSetEventDestinationEventDestinationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.eventDestination = mapped
    }

    /**
     * @param value An object that defines the event destination. See event_destination below.
     */
    @JvmName("gjbbegdemmlonvyr")
    public suspend fun eventDestinationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventDestinationName = mapped
    }

    internal fun build(): ConfigurationSetEventDestinationArgs = ConfigurationSetEventDestinationArgs(
        configurationSetName = configurationSetName,
        eventDestination = eventDestination,
        eventDestinationName = eventDestinationName,
    )
}
