@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin

import com.pulumi.aws.sesv2.kotlin.outputs.ContactListTopic
import com.pulumi.aws.sesv2.kotlin.outputs.ContactListTopic.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ContactList].
 */
@PulumiTagMarker
public class ContactListResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ContactListArgs = ContactListArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ContactListArgsBuilder.() -> Unit) {
        val builder = ContactListArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ContactList {
        val builtJavaResource = com.pulumi.aws.sesv2.ContactList(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ContactList(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS SESv2 (Simple Email V2) Contact List.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.ContactList;
 * import com.pulumi.aws.sesv2.ContactListArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ContactList("example", ContactListArgs.builder()
 *             .contactListName("example")
 *             .build());
 *     }
 * }
 * ```
 * ### Extended Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.ContactList;
 * import com.pulumi.aws.sesv2.ContactListArgs;
 * import com.pulumi.aws.sesv2.inputs.ContactListTopicArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ContactList("example", ContactListArgs.builder()
 *             .contactListName("example")
 *             .description("description")
 *             .topics(ContactListTopicArgs.builder()
 *                 .defaultSubscriptionStatus("OPT_IN")
 *                 .description("topic description")
 *                 .displayName("Example Topic")
 *                 .topicName("example-topic")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SESv2 (Simple Email V2) Contact List using the `example_id_arg`. For example:
 * ```sh
 *  $ pulumi import aws:sesv2/contactList:ContactList example example
 * ```
 *
 */
public class ContactList internal constructor(
    override val javaResource: com.pulumi.aws.sesv2.ContactList,
) : KotlinCustomResource(javaResource, ContactListMapper) {
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The name of the contact list.
     * The following arguments are optional:
     */
    public val contactListName: Output<String>
        get() = javaResource.contactListName().applyValue({ args0 -> args0 })

    /**
     * A timestamp noting when the contact list was created in ISO 8601 format.
     */
    public val createdTimestamp: Output<String>
        get() = javaResource.createdTimestamp().applyValue({ args0 -> args0 })

    /**
     * A description of what the contact list is about.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A timestamp noting the last time the contact list was updated in ISO 8601 format.
     */
    public val lastUpdatedTimestamp: Output<String>
        get() = javaResource.lastUpdatedTimestamp().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags for the contact list. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Configuration block(s) with topic for the contact list. Detailed below.
     */
    public val topics: Output<List<ContactListTopic>>?
        get() = javaResource.topics().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })
}

public object ContactListMapper : ResourceMapper<ContactList> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sesv2.ContactList::class == javaResource::class

    override fun map(javaResource: Resource): ContactList = ContactList(
        javaResource as
            com.pulumi.aws.sesv2.ContactList,
    )
}

/**
 * @see [ContactList].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ContactList].
 */
public suspend fun contactList(name: String, block: suspend ContactListResourceBuilder.() -> Unit):
    ContactList {
    val builder = ContactListResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ContactList].
 * @param name The _unique_ name of the resulting resource.
 */
public fun contactList(name: String): ContactList {
    val builder = ContactListResourceBuilder()
    builder.name(name)
    return builder.build()
}
