@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin

import com.pulumi.aws.sesv2.ContactListArgs.builder
import com.pulumi.aws.sesv2.kotlin.inputs.ContactListTopicArgs
import com.pulumi.aws.sesv2.kotlin.inputs.ContactListTopicArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS SESv2 (Simple Email V2) Contact List.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.ContactList;
 * import com.pulumi.aws.sesv2.ContactListArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ContactList("example", ContactListArgs.builder()
 *             .contactListName("example")
 *             .build());
 *     }
 * }
 * ```
 * ### Extended Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.ContactList;
 * import com.pulumi.aws.sesv2.ContactListArgs;
 * import com.pulumi.aws.sesv2.inputs.ContactListTopicArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ContactList("example", ContactListArgs.builder()
 *             .contactListName("example")
 *             .description("description")
 *             .topics(ContactListTopicArgs.builder()
 *                 .defaultSubscriptionStatus("OPT_IN")
 *                 .description("topic description")
 *                 .displayName("Example Topic")
 *                 .topicName("example-topic")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SESv2 (Simple Email V2) Contact List using the `example_id_arg`. For example:
 * ```sh
 *  $ pulumi import aws:sesv2/contactList:ContactList example example
 * ```
 * @property contactListName The name of the contact list.
 * The following arguments are optional:
 * @property description A description of what the contact list is about.
 * @property tags Key-value map of resource tags for the contact list. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property topics Configuration block(s) with topic for the contact list. Detailed below.
 */
public data class ContactListArgs(
    public val contactListName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val topics: Output<List<ContactListTopicArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.sesv2.ContactListArgs> {
    override fun toJava(): com.pulumi.aws.sesv2.ContactListArgs =
        com.pulumi.aws.sesv2.ContactListArgs.builder()
            .contactListName(contactListName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .topics(
                topics?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ContactListArgs].
 */
@PulumiTagMarker
public class ContactListArgsBuilder internal constructor() {
    private var contactListName: Output<String>? = null

    private var description: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var topics: Output<List<ContactListTopicArgs>>? = null

    /**
     * @param value The name of the contact list.
     * The following arguments are optional:
     */
    @JvmName("iqxnjxovnagdxgen")
    public suspend fun contactListName(`value`: Output<String>) {
        this.contactListName = value
    }

    /**
     * @param value A description of what the contact list is about.
     */
    @JvmName("lkswymseaegdryle")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Key-value map of resource tags for the contact list. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pnnuvokpndujxgqu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Configuration block(s) with topic for the contact list. Detailed below.
     */
    @JvmName("vlwwcyjounypcorl")
    public suspend fun topics(`value`: Output<List<ContactListTopicArgs>>) {
        this.topics = value
    }

    @JvmName("tybkcwcqismsrrnf")
    public suspend fun topics(vararg values: Output<ContactListTopicArgs>) {
        this.topics = Output.all(values.asList())
    }

    /**
     * @param values Configuration block(s) with topic for the contact list. Detailed below.
     */
    @JvmName("bqpkertvccboejln")
    public suspend fun topics(values: List<Output<ContactListTopicArgs>>) {
        this.topics = Output.all(values)
    }

    /**
     * @param value The name of the contact list.
     * The following arguments are optional:
     */
    @JvmName("fakrwtrdcmldowlo")
    public suspend fun contactListName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contactListName = mapped
    }

    /**
     * @param value A description of what the contact list is about.
     */
    @JvmName("vxkrdfstjntnboyu")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Key-value map of resource tags for the contact list. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hbfsiwakmfntssgh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags for the contact list. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wusnkwwdpsyuewaw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Configuration block(s) with topic for the contact list. Detailed below.
     */
    @JvmName("vxdbxtuvebqgsflm")
    public suspend fun topics(`value`: List<ContactListTopicArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topics = mapped
    }

    /**
     * @param argument Configuration block(s) with topic for the contact list. Detailed below.
     */
    @JvmName("psjldkplkowolglo")
    public suspend fun topics(argument: List<suspend ContactListTopicArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContactListTopicArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.topics = mapped
    }

    /**
     * @param argument Configuration block(s) with topic for the contact list. Detailed below.
     */
    @JvmName("mymqvqcpkviwkwdt")
    public suspend fun topics(vararg argument: suspend ContactListTopicArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContactListTopicArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.topics = mapped
    }

    /**
     * @param argument Configuration block(s) with topic for the contact list. Detailed below.
     */
    @JvmName("fwmkwpdulhtynnac")
    public suspend fun topics(argument: suspend ContactListTopicArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ContactListTopicArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.topics = mapped
    }

    /**
     * @param values Configuration block(s) with topic for the contact list. Detailed below.
     */
    @JvmName("adouewomdghsqosc")
    public suspend fun topics(vararg values: ContactListTopicArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.topics = mapped
    }

    internal fun build(): ContactListArgs = ContactListArgs(
        contactListName = contactListName,
        description = description,
        tags = tags,
        topics = topics,
    )
}
