@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin

import com.pulumi.aws.sesv2.DedicatedIpAssignmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS SESv2 (Simple Email V2) Dedicated IP Assignment.
 * This resource is used with "Standard" dedicated IP addresses. This includes addresses [requested and relinquished manually](https://docs&#46;aws&#46;amazon&#46;com/ses/latest/dg/dedicated-ip-case&#46;html) via an AWS support case, or [Bring Your Own IP](https://docs&#46;aws&#46;amazon&#46;com/ses/latest/dg/dedicated-ip-byo&#46;html) addresses&#46; Once no longer assigned, this resource returns the IP to the [`ses-default-dedicated-pool`](https://docs.aws.amazon.com/ses/latest/dg/managing-ip-pools.html), managed by AWS.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.DedicatedIpAssignment;
 * import com.pulumi.aws.sesv2.DedicatedIpAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DedicatedIpAssignment("example", DedicatedIpAssignmentArgs.builder()
 *             .destinationPoolName("my-pool")
 *             .ip("0.0.0.0")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SESv2 (Simple Email V2) Dedicated IP Assignment using the `id`, which is a comma-separated string made up of `ip` and `destination_pool_name`. For example:
 * ```sh
 *  $ pulumi import aws:sesv2/dedicatedIpAssignment:DedicatedIpAssignment example "0.0.0.0,my-pool"
 * ```
 * @property destinationPoolName Dedicated IP address.
 * @property ip Dedicated IP address.
 */
public data class DedicatedIpAssignmentArgs(
    public val destinationPoolName: Output<String>? = null,
    public val ip: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sesv2.DedicatedIpAssignmentArgs> {
    override fun toJava(): com.pulumi.aws.sesv2.DedicatedIpAssignmentArgs =
        com.pulumi.aws.sesv2.DedicatedIpAssignmentArgs.builder()
            .destinationPoolName(destinationPoolName?.applyValue({ args0 -> args0 }))
            .ip(ip?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DedicatedIpAssignmentArgs].
 */
@PulumiTagMarker
public class DedicatedIpAssignmentArgsBuilder internal constructor() {
    private var destinationPoolName: Output<String>? = null

    private var ip: Output<String>? = null

    /**
     * @param value Dedicated IP address.
     */
    @JvmName("jbjpigobcbxkjxrg")
    public suspend fun destinationPoolName(`value`: Output<String>) {
        this.destinationPoolName = value
    }

    /**
     * @param value Dedicated IP address.
     */
    @JvmName("utydedcireqcjehj")
    public suspend fun ip(`value`: Output<String>) {
        this.ip = value
    }

    /**
     * @param value Dedicated IP address.
     */
    @JvmName("xamkouinfterkdln")
    public suspend fun destinationPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationPoolName = mapped
    }

    /**
     * @param value Dedicated IP address.
     */
    @JvmName("iaobhwbdwearplot")
    public suspend fun ip(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ip = mapped
    }

    internal fun build(): DedicatedIpAssignmentArgs = DedicatedIpAssignmentArgs(
        destinationPoolName = destinationPoolName,
        ip = ip,
    )
}
