@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin

import com.pulumi.aws.sesv2.kotlin.outputs.EmailIdentityDkimSigningAttributes
import com.pulumi.aws.sesv2.kotlin.outputs.EmailIdentityDkimSigningAttributes.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [EmailIdentity].
 */
@PulumiTagMarker
public class EmailIdentityResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EmailIdentityArgs = EmailIdentityArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EmailIdentityArgsBuilder.() -> Unit) {
        val builder = EmailIdentityArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): EmailIdentity {
        val builtJavaResource = com.pulumi.aws.sesv2.EmailIdentity(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EmailIdentity(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS SESv2 (Simple Email V2) Email Identity.
 * ## Example Usage
 * ### Basic Usage
 * ### Email Address Identity
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.EmailIdentity;
 * import com.pulumi.aws.sesv2.EmailIdentityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EmailIdentity("example", EmailIdentityArgs.builder()
 *             .emailIdentity("testing@example.com")
 *             .build());
 *     }
 * }
 * ```
 * ### Domain Identity
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.EmailIdentity;
 * import com.pulumi.aws.sesv2.EmailIdentityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EmailIdentity("example", EmailIdentityArgs.builder()
 *             .emailIdentity("example.com")
 *             .build());
 *     }
 * }
 * ```
 * ### Configuration Set
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.ConfigurationSet;
 * import com.pulumi.aws.sesv2.ConfigurationSetArgs;
 * import com.pulumi.aws.sesv2.EmailIdentity;
 * import com.pulumi.aws.sesv2.EmailIdentityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleConfigurationSet = new ConfigurationSet("exampleConfigurationSet", ConfigurationSetArgs.builder()
 *             .configurationSetName("example")
 *             .build());
 *         var exampleEmailIdentity = new EmailIdentity("exampleEmailIdentity", EmailIdentityArgs.builder()
 *             .emailIdentity("example.com")
 *             .configurationSetName(exampleConfigurationSet.configurationSetName())
 *             .build());
 *     }
 * }
 * ```
 * ### DKIM Signing Attributes (BYODKIM)
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.EmailIdentity;
 * import com.pulumi.aws.sesv2.EmailIdentityArgs;
 * import com.pulumi.aws.sesv2.inputs.EmailIdentityDkimSigningAttributesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EmailIdentity("example", EmailIdentityArgs.builder()
 *             .dkimSigningAttributes(EmailIdentityDkimSigningAttributesArgs.builder()
 *                 .domainSigningPrivateKey("MIIJKAIBAAKCAgEA2Se7p8zvnI4yh+Gh9j2rG5e2aRXjg03Y8saiupLnadPH9xvM...")
 *                 .domainSigningSelector("example")
 *                 .build())
 *             .emailIdentity("example.com")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SESv2 (Simple Email V2) Email Identity using the `email_identity`. For example:
 * ```sh
 *  $ pulumi import aws:sesv2/emailIdentity:EmailIdentity example example.com
 * ```
 *
 */
public class EmailIdentity internal constructor(
    override val javaResource: com.pulumi.aws.sesv2.EmailIdentity,
) : KotlinCustomResource(javaResource, EmailIdentityMapper) {
    /**
     * ARN of the Email Identity.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The configuration set to use by default when sending from this identity. Note that any configuration set defined in the email sending request takes precedence.
     */
    public val configurationSetName: Output<String>?
        get() = javaResource.configurationSetName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The configuration of the DKIM authentication settings for an email domain identity.
     */
    public val dkimSigningAttributes: Output<EmailIdentityDkimSigningAttributes>
        get() = javaResource.dkimSigningAttributes().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * The email address or domain to verify.
     * The following arguments are optional:
     */
    public val emailIdentity: Output<String>
        get() = javaResource.emailIdentity().applyValue({ args0 -> args0 })

    /**
     * The email identity type. Valid values: `EMAIL_ADDRESS`, `DOMAIN`.
     */
    public val identityType: Output<String>
        get() = javaResource.identityType().applyValue({ args0 -> args0 })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Specifies whether or not the identity is verified.
     */
    public val verifiedForSendingStatus: Output<Boolean>
        get() = javaResource.verifiedForSendingStatus().applyValue({ args0 -> args0 })
}

public object EmailIdentityMapper : ResourceMapper<EmailIdentity> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sesv2.EmailIdentity::class == javaResource::class

    override fun map(javaResource: Resource): EmailIdentity = EmailIdentity(
        javaResource as
            com.pulumi.aws.sesv2.EmailIdentity,
    )
}

/**
 * @see [EmailIdentity].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EmailIdentity].
 */
public suspend fun emailIdentity(
    name: String,
    block: suspend EmailIdentityResourceBuilder.() -> Unit,
): EmailIdentity {
    val builder = EmailIdentityResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EmailIdentity].
 * @param name The _unique_ name of the resulting resource.
 */
public fun emailIdentity(name: String): EmailIdentity {
    val builder = EmailIdentityResourceBuilder()
    builder.name(name)
    return builder.build()
}
