@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin

import com.pulumi.aws.sesv2.EmailIdentityArgs.builder
import com.pulumi.aws.sesv2.kotlin.inputs.EmailIdentityDkimSigningAttributesArgs
import com.pulumi.aws.sesv2.kotlin.inputs.EmailIdentityDkimSigningAttributesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS SESv2 (Simple Email V2) Email Identity.
 * ## Example Usage
 * ### Basic Usage
 * ### Email Address Identity
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.EmailIdentity;
 * import com.pulumi.aws.sesv2.EmailIdentityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EmailIdentity("example", EmailIdentityArgs.builder()
 *             .emailIdentity("testing@example.com")
 *             .build());
 *     }
 * }
 * ```
 * ### Domain Identity
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.EmailIdentity;
 * import com.pulumi.aws.sesv2.EmailIdentityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EmailIdentity("example", EmailIdentityArgs.builder()
 *             .emailIdentity("example.com")
 *             .build());
 *     }
 * }
 * ```
 * ### Configuration Set
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.ConfigurationSet;
 * import com.pulumi.aws.sesv2.ConfigurationSetArgs;
 * import com.pulumi.aws.sesv2.EmailIdentity;
 * import com.pulumi.aws.sesv2.EmailIdentityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleConfigurationSet = new ConfigurationSet("exampleConfigurationSet", ConfigurationSetArgs.builder()
 *             .configurationSetName("example")
 *             .build());
 *         var exampleEmailIdentity = new EmailIdentity("exampleEmailIdentity", EmailIdentityArgs.builder()
 *             .emailIdentity("example.com")
 *             .configurationSetName(exampleConfigurationSet.configurationSetName())
 *             .build());
 *     }
 * }
 * ```
 * ### DKIM Signing Attributes (BYODKIM)
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.EmailIdentity;
 * import com.pulumi.aws.sesv2.EmailIdentityArgs;
 * import com.pulumi.aws.sesv2.inputs.EmailIdentityDkimSigningAttributesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EmailIdentity("example", EmailIdentityArgs.builder()
 *             .dkimSigningAttributes(EmailIdentityDkimSigningAttributesArgs.builder()
 *                 .domainSigningPrivateKey("MIIJKAIBAAKCAgEA2Se7p8zvnI4yh+Gh9j2rG5e2aRXjg03Y8saiupLnadPH9xvM...")
 *                 .domainSigningSelector("example")
 *                 .build())
 *             .emailIdentity("example.com")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SESv2 (Simple Email V2) Email Identity using the `email_identity`. For example:
 * ```sh
 *  $ pulumi import aws:sesv2/emailIdentity:EmailIdentity example example.com
 * ```
 * @property configurationSetName The configuration set to use by default when sending from this identity. Note that any configuration set defined in the email sending request takes precedence.
 * @property dkimSigningAttributes The configuration of the DKIM authentication settings for an email domain identity.
 * @property emailIdentity The email address or domain to verify.
 * The following arguments are optional:
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class EmailIdentityArgs(
    public val configurationSetName: Output<String>? = null,
    public val dkimSigningAttributes: Output<EmailIdentityDkimSigningAttributesArgs>? = null,
    public val emailIdentity: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.sesv2.EmailIdentityArgs> {
    override fun toJava(): com.pulumi.aws.sesv2.EmailIdentityArgs =
        com.pulumi.aws.sesv2.EmailIdentityArgs.builder()
            .configurationSetName(configurationSetName?.applyValue({ args0 -> args0 }))
            .dkimSigningAttributes(
                dkimSigningAttributes?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .emailIdentity(emailIdentity?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [EmailIdentityArgs].
 */
@PulumiTagMarker
public class EmailIdentityArgsBuilder internal constructor() {
    private var configurationSetName: Output<String>? = null

    private var dkimSigningAttributes: Output<EmailIdentityDkimSigningAttributesArgs>? = null

    private var emailIdentity: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The configuration set to use by default when sending from this identity. Note that any configuration set defined in the email sending request takes precedence.
     */
    @JvmName("nctvlimugedtjeal")
    public suspend fun configurationSetName(`value`: Output<String>) {
        this.configurationSetName = value
    }

    /**
     * @param value The configuration of the DKIM authentication settings for an email domain identity.
     */
    @JvmName("bfpmmheacpqkgaoo")
    public suspend
    fun dkimSigningAttributes(`value`: Output<EmailIdentityDkimSigningAttributesArgs>) {
        this.dkimSigningAttributes = value
    }

    /**
     * @param value The email address or domain to verify.
     * The following arguments are optional:
     */
    @JvmName("bhfwrbvjejdqumns")
    public suspend fun emailIdentity(`value`: Output<String>) {
        this.emailIdentity = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pulmuqgfeatcxcys")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The configuration set to use by default when sending from this identity. Note that any configuration set defined in the email sending request takes precedence.
     */
    @JvmName("ktouyifcdjbtydwv")
    public suspend fun configurationSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationSetName = mapped
    }

    /**
     * @param value The configuration of the DKIM authentication settings for an email domain identity.
     */
    @JvmName("dclloxdglvsognly")
    public suspend fun dkimSigningAttributes(`value`: EmailIdentityDkimSigningAttributesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dkimSigningAttributes = mapped
    }

    /**
     * @param argument The configuration of the DKIM authentication settings for an email domain identity.
     */
    @JvmName("gxwrmnmggidkcnjx")
    public suspend
    fun dkimSigningAttributes(argument: suspend EmailIdentityDkimSigningAttributesArgsBuilder.() -> Unit) {
        val toBeMapped = EmailIdentityDkimSigningAttributesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dkimSigningAttributes = mapped
    }

    /**
     * @param value The email address or domain to verify.
     * The following arguments are optional:
     */
    @JvmName("wugtolqhmctghxyu")
    public suspend fun emailIdentity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailIdentity = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mcvstmvhaslrltwn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("sgfuiwukoxabcbum")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): EmailIdentityArgs = EmailIdentityArgs(
        configurationSetName = configurationSetName,
        dkimSigningAttributes = dkimSigningAttributes,
        emailIdentity = emailIdentity,
        tags = tags,
    )
}
