@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EmailIdentityFeedbackAttributes].
 */
@PulumiTagMarker
public class EmailIdentityFeedbackAttributesResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EmailIdentityFeedbackAttributesArgs = EmailIdentityFeedbackAttributesArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EmailIdentityFeedbackAttributesArgsBuilder.() -> Unit) {
        val builder = EmailIdentityFeedbackAttributesArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): EmailIdentityFeedbackAttributes {
        val builtJavaResource =
            com.pulumi.aws.sesv2.EmailIdentityFeedbackAttributes(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return EmailIdentityFeedbackAttributes(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS SESv2 (Simple Email V2) Email Identity Feedback Attributes.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.EmailIdentity;
 * import com.pulumi.aws.sesv2.EmailIdentityArgs;
 * import com.pulumi.aws.sesv2.EmailIdentityFeedbackAttributes;
 * import com.pulumi.aws.sesv2.EmailIdentityFeedbackAttributesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleEmailIdentity = new EmailIdentity("exampleEmailIdentity", EmailIdentityArgs.builder()
 *             .emailIdentity("example.com")
 *             .build());
 *         var exampleEmailIdentityFeedbackAttributes = new EmailIdentityFeedbackAttributes("exampleEmailIdentityFeedbackAttributes", EmailIdentityFeedbackAttributesArgs.builder()
 *             .emailIdentity(exampleEmailIdentity.emailIdentity())
 *             .emailForwardingEnabled(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SESv2 (Simple Email V2) Email Identity Feedback Attributes using the `email_identity`. For example:
 * ```sh
 *  $ pulumi import aws:sesv2/emailIdentityFeedbackAttributes:EmailIdentityFeedbackAttributes example example.com
 * ```
 *
 */
public class EmailIdentityFeedbackAttributes internal constructor(
    override val javaResource: com.pulumi.aws.sesv2.EmailIdentityFeedbackAttributes,
) : KotlinCustomResource(javaResource, EmailIdentityFeedbackAttributesMapper) {
    /**
     * Sets the feedback forwarding configuration for the identity.
     */
    public val emailForwardingEnabled: Output<Boolean>?
        get() = javaResource.emailForwardingEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The email identity.
     */
    public val emailIdentity: Output<String>
        get() = javaResource.emailIdentity().applyValue({ args0 -> args0 })
}

public object EmailIdentityFeedbackAttributesMapper :
    ResourceMapper<EmailIdentityFeedbackAttributes> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sesv2.EmailIdentityFeedbackAttributes::class == javaResource::class

    override fun map(javaResource: Resource): EmailIdentityFeedbackAttributes =
        EmailIdentityFeedbackAttributes(
            javaResource as
                com.pulumi.aws.sesv2.EmailIdentityFeedbackAttributes,
        )
}

/**
 * @see [EmailIdentityFeedbackAttributes].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EmailIdentityFeedbackAttributes].
 */
public suspend fun emailIdentityFeedbackAttributes(
    name: String,
    block: suspend EmailIdentityFeedbackAttributesResourceBuilder.() -> Unit,
):
    EmailIdentityFeedbackAttributes {
    val builder = EmailIdentityFeedbackAttributesResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EmailIdentityFeedbackAttributes].
 * @param name The _unique_ name of the resulting resource.
 */
public fun emailIdentityFeedbackAttributes(name: String): EmailIdentityFeedbackAttributes {
    val builder = EmailIdentityFeedbackAttributesResourceBuilder()
    builder.name(name)
    return builder.build()
}
