@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin

import com.pulumi.aws.sesv2.EmailIdentityFeedbackAttributesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS SESv2 (Simple Email V2) Email Identity Feedback Attributes.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.EmailIdentity;
 * import com.pulumi.aws.sesv2.EmailIdentityArgs;
 * import com.pulumi.aws.sesv2.EmailIdentityFeedbackAttributes;
 * import com.pulumi.aws.sesv2.EmailIdentityFeedbackAttributesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleEmailIdentity = new EmailIdentity("exampleEmailIdentity", EmailIdentityArgs.builder()
 *             .emailIdentity("example.com")
 *             .build());
 *         var exampleEmailIdentityFeedbackAttributes = new EmailIdentityFeedbackAttributes("exampleEmailIdentityFeedbackAttributes", EmailIdentityFeedbackAttributesArgs.builder()
 *             .emailIdentity(exampleEmailIdentity.emailIdentity())
 *             .emailForwardingEnabled(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SESv2 (Simple Email V2) Email Identity Feedback Attributes using the `email_identity`. For example:
 * ```sh
 *  $ pulumi import aws:sesv2/emailIdentityFeedbackAttributes:EmailIdentityFeedbackAttributes example example.com
 * ```
 * @property emailForwardingEnabled Sets the feedback forwarding configuration for the identity.
 * @property emailIdentity The email identity.
 */
public data class EmailIdentityFeedbackAttributesArgs(
    public val emailForwardingEnabled: Output<Boolean>? = null,
    public val emailIdentity: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sesv2.EmailIdentityFeedbackAttributesArgs> {
    override fun toJava(): com.pulumi.aws.sesv2.EmailIdentityFeedbackAttributesArgs =
        com.pulumi.aws.sesv2.EmailIdentityFeedbackAttributesArgs.builder()
            .emailForwardingEnabled(emailForwardingEnabled?.applyValue({ args0 -> args0 }))
            .emailIdentity(emailIdentity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EmailIdentityFeedbackAttributesArgs].
 */
@PulumiTagMarker
public class EmailIdentityFeedbackAttributesArgsBuilder internal constructor() {
    private var emailForwardingEnabled: Output<Boolean>? = null

    private var emailIdentity: Output<String>? = null

    /**
     * @param value Sets the feedback forwarding configuration for the identity.
     */
    @JvmName("jvhtnpeikickpqre")
    public suspend fun emailForwardingEnabled(`value`: Output<Boolean>) {
        this.emailForwardingEnabled = value
    }

    /**
     * @param value The email identity.
     */
    @JvmName("rksjiedaxrewqnqy")
    public suspend fun emailIdentity(`value`: Output<String>) {
        this.emailIdentity = value
    }

    /**
     * @param value Sets the feedback forwarding configuration for the identity.
     */
    @JvmName("bylgdbvtmmqtjfhw")
    public suspend fun emailForwardingEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailForwardingEnabled = mapped
    }

    /**
     * @param value The email identity.
     */
    @JvmName("vqheqofnagmucheg")
    public suspend fun emailIdentity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailIdentity = mapped
    }

    internal fun build(): EmailIdentityFeedbackAttributesArgs = EmailIdentityFeedbackAttributesArgs(
        emailForwardingEnabled = emailForwardingEnabled,
        emailIdentity = emailIdentity,
    )
}
