@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin

import com.pulumi.aws.sesv2.EmailIdentityMailFromAttributesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS SESv2 (Simple Email V2) Email Identity Mail From Attributes.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.EmailIdentity;
 * import com.pulumi.aws.sesv2.EmailIdentityArgs;
 * import com.pulumi.aws.sesv2.EmailIdentityMailFromAttributes;
 * import com.pulumi.aws.sesv2.EmailIdentityMailFromAttributesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleEmailIdentity = new EmailIdentity("exampleEmailIdentity", EmailIdentityArgs.builder()
 *             .emailIdentity("example.com")
 *             .build());
 *         var exampleEmailIdentityMailFromAttributes = new EmailIdentityMailFromAttributes("exampleEmailIdentityMailFromAttributes", EmailIdentityMailFromAttributesArgs.builder()
 *             .emailIdentity(exampleEmailIdentity.emailIdentity())
 *             .behaviorOnMxFailure("REJECT_MESSAGE")
 *             .mailFromDomain(exampleEmailIdentity.emailIdentity().applyValue(emailIdentity -> String.format("subdomain.%s", emailIdentity)))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SESv2 (Simple Email V2) Email Identity Mail From Attributes using the `email_identity`. For example:
 * ```sh
 *  $ pulumi import aws:sesv2/emailIdentityMailFromAttributes:EmailIdentityMailFromAttributes example example.com
 * ```
 * @property behaviorOnMxFailure The action to take if the required MX record isn't found when you send an email. Valid values: `USE_DEFAULT_VALUE`, `REJECT_MESSAGE`.
 * @property emailIdentity The verified email identity.
 * @property mailFromDomain The custom MAIL FROM domain that you want the verified identity to use. Required if `behavior_on_mx_failure` is `REJECT_MESSAGE`.
 */
public data class EmailIdentityMailFromAttributesArgs(
    public val behaviorOnMxFailure: Output<String>? = null,
    public val emailIdentity: Output<String>? = null,
    public val mailFromDomain: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sesv2.EmailIdentityMailFromAttributesArgs> {
    override fun toJava(): com.pulumi.aws.sesv2.EmailIdentityMailFromAttributesArgs =
        com.pulumi.aws.sesv2.EmailIdentityMailFromAttributesArgs.builder()
            .behaviorOnMxFailure(behaviorOnMxFailure?.applyValue({ args0 -> args0 }))
            .emailIdentity(emailIdentity?.applyValue({ args0 -> args0 }))
            .mailFromDomain(mailFromDomain?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EmailIdentityMailFromAttributesArgs].
 */
@PulumiTagMarker
public class EmailIdentityMailFromAttributesArgsBuilder internal constructor() {
    private var behaviorOnMxFailure: Output<String>? = null

    private var emailIdentity: Output<String>? = null

    private var mailFromDomain: Output<String>? = null

    /**
     * @param value The action to take if the required MX record isn't found when you send an email. Valid values: `USE_DEFAULT_VALUE`, `REJECT_MESSAGE`.
     */
    @JvmName("rwvxybpnirfidxsd")
    public suspend fun behaviorOnMxFailure(`value`: Output<String>) {
        this.behaviorOnMxFailure = value
    }

    /**
     * @param value The verified email identity.
     */
    @JvmName("pgifjwumebxcwvvh")
    public suspend fun emailIdentity(`value`: Output<String>) {
        this.emailIdentity = value
    }

    /**
     * @param value The custom MAIL FROM domain that you want the verified identity to use. Required if `behavior_on_mx_failure` is `REJECT_MESSAGE`.
     */
    @JvmName("xjrbxthxmygxrbfp")
    public suspend fun mailFromDomain(`value`: Output<String>) {
        this.mailFromDomain = value
    }

    /**
     * @param value The action to take if the required MX record isn't found when you send an email. Valid values: `USE_DEFAULT_VALUE`, `REJECT_MESSAGE`.
     */
    @JvmName("paqpttnrxpmrnwgu")
    public suspend fun behaviorOnMxFailure(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.behaviorOnMxFailure = mapped
    }

    /**
     * @param value The verified email identity.
     */
    @JvmName("apmwybmivingybnl")
    public suspend fun emailIdentity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailIdentity = mapped
    }

    /**
     * @param value The custom MAIL FROM domain that you want the verified identity to use. Required if `behavior_on_mx_failure` is `REJECT_MESSAGE`.
     */
    @JvmName("mdhoftqhvoqkyjpq")
    public suspend fun mailFromDomain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mailFromDomain = mapped
    }

    internal fun build(): EmailIdentityMailFromAttributesArgs = EmailIdentityMailFromAttributesArgs(
        behaviorOnMxFailure = behaviorOnMxFailure,
        emailIdentity = emailIdentity,
        mailFromDomain = mailFromDomain,
    )
}
