@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin

import com.pulumi.aws.sesv2.Sesv2Functions.getConfigurationSetPlain
import com.pulumi.aws.sesv2.Sesv2Functions.getDedicatedIpPoolPlain
import com.pulumi.aws.sesv2.Sesv2Functions.getEmailIdentityMailFromAttributesPlain
import com.pulumi.aws.sesv2.Sesv2Functions.getEmailIdentityPlain
import com.pulumi.aws.sesv2.kotlin.inputs.GetConfigurationSetPlainArgs
import com.pulumi.aws.sesv2.kotlin.inputs.GetConfigurationSetPlainArgsBuilder
import com.pulumi.aws.sesv2.kotlin.inputs.GetDedicatedIpPoolPlainArgs
import com.pulumi.aws.sesv2.kotlin.inputs.GetDedicatedIpPoolPlainArgsBuilder
import com.pulumi.aws.sesv2.kotlin.inputs.GetEmailIdentityMailFromAttributesPlainArgs
import com.pulumi.aws.sesv2.kotlin.inputs.GetEmailIdentityMailFromAttributesPlainArgsBuilder
import com.pulumi.aws.sesv2.kotlin.inputs.GetEmailIdentityPlainArgs
import com.pulumi.aws.sesv2.kotlin.inputs.GetEmailIdentityPlainArgsBuilder
import com.pulumi.aws.sesv2.kotlin.outputs.GetConfigurationSetResult
import com.pulumi.aws.sesv2.kotlin.outputs.GetDedicatedIpPoolResult
import com.pulumi.aws.sesv2.kotlin.outputs.GetEmailIdentityMailFromAttributesResult
import com.pulumi.aws.sesv2.kotlin.outputs.GetEmailIdentityResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.sesv2.kotlin.outputs.GetConfigurationSetResult.Companion.toKotlin as getConfigurationSetResultToKotlin
import com.pulumi.aws.sesv2.kotlin.outputs.GetDedicatedIpPoolResult.Companion.toKotlin as getDedicatedIpPoolResultToKotlin
import com.pulumi.aws.sesv2.kotlin.outputs.GetEmailIdentityMailFromAttributesResult.Companion.toKotlin as getEmailIdentityMailFromAttributesResultToKotlin
import com.pulumi.aws.sesv2.kotlin.outputs.GetEmailIdentityResult.Companion.toKotlin as getEmailIdentityResultToKotlin

public object Sesv2Functions {
    /**
     * Data source for managing an AWS SESv2 (Simple Email V2) Configuration Set.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.sesv2.Sesv2Functions;
     * import com.pulumi.aws.sesv2.inputs.GetConfigurationSetArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Sesv2Functions.getConfigurationSet(GetConfigurationSetArgs.builder()
     *             .configurationSetName("example")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getConfigurationSet.
     * @return A collection of values returned by getConfigurationSet.
     */
    public suspend fun getConfigurationSet(argument: GetConfigurationSetPlainArgs):
        GetConfigurationSetResult =
        getConfigurationSetResultToKotlin(getConfigurationSetPlain(argument.toJava()).await())

    /**
     * @see [getConfigurationSet].
     * @param configurationSetName The name of the configuration set.
     * @param tags Key-value map of resource tags for the container recipe.
     * @return A collection of values returned by getConfigurationSet.
     */
    public suspend fun getConfigurationSet(
        configurationSetName: String,
        tags: Map<String, String>? =
            null,
    ): GetConfigurationSetResult {
        val argument = GetConfigurationSetPlainArgs(
            configurationSetName = configurationSetName,
            tags = tags,
        )
        return getConfigurationSetResultToKotlin(getConfigurationSetPlain(argument.toJava()).await())
    }

    /**
     * @see [getConfigurationSet].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;sesv2&#46;kotlin&#46;inputs&#46;GetConfigurationSetPlainArgs].
     * @return A collection of values returned by getConfigurationSet.
     */
    public suspend
    fun getConfigurationSet(argument: suspend GetConfigurationSetPlainArgsBuilder.() -> Unit):
        GetConfigurationSetResult {
        val builder = GetConfigurationSetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConfigurationSetResultToKotlin(getConfigurationSetPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS SESv2 (Simple Email V2) Dedicated IP Pool.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.sesv2.Sesv2Functions;
     * import com.pulumi.aws.sesv2.inputs.GetDedicatedIpPoolArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Sesv2Functions.getDedicatedIpPool(GetDedicatedIpPoolArgs.builder()
     *             .poolName("my-pool")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getDedicatedIpPool.
     * @return A collection of values returned by getDedicatedIpPool.
     */
    public suspend fun getDedicatedIpPool(argument: GetDedicatedIpPoolPlainArgs):
        GetDedicatedIpPoolResult =
        getDedicatedIpPoolResultToKotlin(getDedicatedIpPoolPlain(argument.toJava()).await())

    /**
     * @see [getDedicatedIpPool].
     * @param poolName Name of the dedicated IP pool.
     * @param tags A map of tags attached to the pool.
     * @return A collection of values returned by getDedicatedIpPool.
     */
    public suspend fun getDedicatedIpPool(poolName: String, tags: Map<String, String>? = null):
        GetDedicatedIpPoolResult {
        val argument = GetDedicatedIpPoolPlainArgs(
            poolName = poolName,
            tags = tags,
        )
        return getDedicatedIpPoolResultToKotlin(getDedicatedIpPoolPlain(argument.toJava()).await())
    }

    /**
     * @see [getDedicatedIpPool].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;sesv2&#46;kotlin&#46;inputs&#46;GetDedicatedIpPoolPlainArgs].
     * @return A collection of values returned by getDedicatedIpPool.
     */
    public suspend
    fun getDedicatedIpPool(argument: suspend GetDedicatedIpPoolPlainArgsBuilder.() -> Unit):
        GetDedicatedIpPoolResult {
        val builder = GetDedicatedIpPoolPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDedicatedIpPoolResultToKotlin(getDedicatedIpPoolPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS SESv2 (Simple Email V2) Email Identity.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.sesv2.Sesv2Functions;
     * import com.pulumi.aws.sesv2.inputs.GetEmailIdentityArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Sesv2Functions.getEmailIdentity(GetEmailIdentityArgs.builder()
     *             .emailIdentity("example.com")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getEmailIdentity.
     * @return A collection of values returned by getEmailIdentity.
     */
    public suspend fun getEmailIdentity(argument: GetEmailIdentityPlainArgs): GetEmailIdentityResult =
        getEmailIdentityResultToKotlin(getEmailIdentityPlain(argument.toJava()).await())

    /**
     * @see [getEmailIdentity].
     * @param emailIdentity The name of the email identity.
     * @param tags Key-value mapping of resource tags.
     * @return A collection of values returned by getEmailIdentity.
     */
    public suspend fun getEmailIdentity(emailIdentity: String, tags: Map<String, String>? = null):
        GetEmailIdentityResult {
        val argument = GetEmailIdentityPlainArgs(
            emailIdentity = emailIdentity,
            tags = tags,
        )
        return getEmailIdentityResultToKotlin(getEmailIdentityPlain(argument.toJava()).await())
    }

    /**
     * @see [getEmailIdentity].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;sesv2&#46;kotlin&#46;inputs&#46;GetEmailIdentityPlainArgs].
     * @return A collection of values returned by getEmailIdentity.
     */
    public suspend
    fun getEmailIdentity(argument: suspend GetEmailIdentityPlainArgsBuilder.() -> Unit):
        GetEmailIdentityResult {
        val builder = GetEmailIdentityPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEmailIdentityResultToKotlin(getEmailIdentityPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS SESv2 (Simple Email V2) Email Identity Mail From Attributes.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.sesv2.Sesv2Functions;
     * import com.pulumi.aws.sesv2.inputs.GetEmailIdentityArgs;
     * import com.pulumi.aws.sesv2.inputs.GetEmailIdentityMailFromAttributesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var exampleEmailIdentity = Sesv2Functions.getEmailIdentity(GetEmailIdentityArgs.builder()
     *             .emailIdentity("example.com")
     *             .build());
     *         final var exampleEmailIdentityMailFromAttributes = Sesv2Functions.getEmailIdentityMailFromAttributes(GetEmailIdentityMailFromAttributesArgs.builder()
     *             .emailIdentity(exampleEmailIdentity.applyValue(getEmailIdentityResult -> getEmailIdentityResult.emailIdentity()))
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getEmailIdentityMailFromAttributes.
     * @return A collection of values returned by getEmailIdentityMailFromAttributes.
     */
    public suspend
    fun getEmailIdentityMailFromAttributes(argument: GetEmailIdentityMailFromAttributesPlainArgs):
        GetEmailIdentityMailFromAttributesResult =
        getEmailIdentityMailFromAttributesResultToKotlin(getEmailIdentityMailFromAttributesPlain(argument.toJava()).await())

    /**
     * @see [getEmailIdentityMailFromAttributes].
     * @param emailIdentity The name of the email identity.
     * @return A collection of values returned by getEmailIdentityMailFromAttributes.
     */
    public suspend fun getEmailIdentityMailFromAttributes(emailIdentity: String):
        GetEmailIdentityMailFromAttributesResult {
        val argument = GetEmailIdentityMailFromAttributesPlainArgs(
            emailIdentity = emailIdentity,
        )
        return getEmailIdentityMailFromAttributesResultToKotlin(getEmailIdentityMailFromAttributesPlain(argument.toJava()).await())
    }

    /**
     * @see [getEmailIdentityMailFromAttributes].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;sesv2&#46;kotlin&#46;inputs&#46;GetEmailIdentityMailFromAttributesPlainArgs].
     * @return A collection of values returned by getEmailIdentityMailFromAttributes.
     */
    public suspend
    fun getEmailIdentityMailFromAttributes(argument: suspend GetEmailIdentityMailFromAttributesPlainArgsBuilder.() -> Unit):
        GetEmailIdentityMailFromAttributesResult {
        val builder = GetEmailIdentityMailFromAttributesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEmailIdentityMailFromAttributesResultToKotlin(getEmailIdentityMailFromAttributesPlain(builtArgument.toJava()).await())
    }
}
