@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin.inputs

import com.pulumi.aws.sesv2.inputs.ConfigurationSetDeliveryOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property sendingPoolName The name of the dedicated IP pool to associate with the configuration set.
 * @property tlsPolicy Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS). Valid values: `REQUIRE`, `OPTIONAL`.
 */
public data class ConfigurationSetDeliveryOptionsArgs(
    public val sendingPoolName: Output<String>? = null,
    public val tlsPolicy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sesv2.inputs.ConfigurationSetDeliveryOptionsArgs> {
    override fun toJava(): com.pulumi.aws.sesv2.inputs.ConfigurationSetDeliveryOptionsArgs =
        com.pulumi.aws.sesv2.inputs.ConfigurationSetDeliveryOptionsArgs.builder()
            .sendingPoolName(sendingPoolName?.applyValue({ args0 -> args0 }))
            .tlsPolicy(tlsPolicy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigurationSetDeliveryOptionsArgs].
 */
@PulumiTagMarker
public class ConfigurationSetDeliveryOptionsArgsBuilder internal constructor() {
    private var sendingPoolName: Output<String>? = null

    private var tlsPolicy: Output<String>? = null

    /**
     * @param value The name of the dedicated IP pool to associate with the configuration set.
     */
    @JvmName("ooamhjciafwmwtxq")
    public suspend fun sendingPoolName(`value`: Output<String>) {
        this.sendingPoolName = value
    }

    /**
     * @param value Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS). Valid values: `REQUIRE`, `OPTIONAL`.
     */
    @JvmName("tfhonywxoicyfcvu")
    public suspend fun tlsPolicy(`value`: Output<String>) {
        this.tlsPolicy = value
    }

    /**
     * @param value The name of the dedicated IP pool to associate with the configuration set.
     */
    @JvmName("cibrdpjedmbtafql")
    public suspend fun sendingPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sendingPoolName = mapped
    }

    /**
     * @param value Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS). Valid values: `REQUIRE`, `OPTIONAL`.
     */
    @JvmName("oxxyjmmmouopnvfh")
    public suspend fun tlsPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tlsPolicy = mapped
    }

    internal fun build(): ConfigurationSetDeliveryOptionsArgs = ConfigurationSetDeliveryOptionsArgs(
        sendingPoolName = sendingPoolName,
        tlsPolicy = tlsPolicy,
    )
}
