@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin.inputs

import com.pulumi.aws.sesv2.inputs.ConfigurationSetEventDestinationEventDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property cloudWatchDestination An object that defines an Amazon CloudWatch destination for email events. See cloud_watch_destination below
 * @property enabled When the event destination is enabled, the specified event types are sent to the destinations. Default: `false`.
 * @property kinesisFirehoseDestination An object that defines an Amazon Kinesis Data Firehose destination for email events. See kinesis_firehose_destination below.
 * @property matchingEventTypes An array that specifies which events the Amazon SES API v2 should send to the destinations. Valid values: `SEND`, `REJECT`, `BOUNCE`, `COMPLAINT`, `DELIVERY`, `OPEN`, `CLICK`, `RENDERING_FAILURE`, `DELIVERY_DELAY`, `SUBSCRIPTION`.
 * The following arguments are optional:
 * @property pinpointDestination An object that defines an Amazon Pinpoint project destination for email events. See pinpoint_destination below.
 * @property snsDestination An object that defines an Amazon SNS destination for email events. See sns_destination below.
 */
public data class ConfigurationSetEventDestinationEventDestinationArgs(
    public val cloudWatchDestination:
    Output<ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationArgs>? = null,
    public val enabled: Output<Boolean>? = null,
    public val kinesisFirehoseDestination:
    Output<ConfigurationSetEventDestinationEventDestinationKinesisFirehoseDestinationArgs>? =
        null,
    public val matchingEventTypes: Output<List<String>>,
    public val pinpointDestination:
    Output<ConfigurationSetEventDestinationEventDestinationPinpointDestinationArgs>? = null,
    public val snsDestination:
    Output<ConfigurationSetEventDestinationEventDestinationSnsDestinationArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sesv2.inputs.ConfigurationSetEventDestinationEventDestinationArgs> {
    override fun toJava():
        com.pulumi.aws.sesv2.inputs.ConfigurationSetEventDestinationEventDestinationArgs =
        com.pulumi.aws.sesv2.inputs.ConfigurationSetEventDestinationEventDestinationArgs.builder()
            .cloudWatchDestination(
                cloudWatchDestination?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .kinesisFirehoseDestination(
                kinesisFirehoseDestination?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .matchingEventTypes(matchingEventTypes.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .pinpointDestination(
                pinpointDestination?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .snsDestination(
                snsDestination?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ConfigurationSetEventDestinationEventDestinationArgs].
 */
@PulumiTagMarker
public class ConfigurationSetEventDestinationEventDestinationArgsBuilder internal constructor() {
    private var cloudWatchDestination:
        Output<ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationArgs>? = null

    private var enabled: Output<Boolean>? = null

    private var kinesisFirehoseDestination:
        Output<ConfigurationSetEventDestinationEventDestinationKinesisFirehoseDestinationArgs>? = null

    private var matchingEventTypes: Output<List<String>>? = null

    private var pinpointDestination:
        Output<ConfigurationSetEventDestinationEventDestinationPinpointDestinationArgs>? = null

    private var snsDestination:
        Output<ConfigurationSetEventDestinationEventDestinationSnsDestinationArgs>? = null

    /**
     * @param value An object that defines an Amazon CloudWatch destination for email events. See cloud_watch_destination below
     */
    @JvmName("optqhafliesgrtue")
    public suspend
    fun cloudWatchDestination(`value`: Output<ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationArgs>) {
        this.cloudWatchDestination = value
    }

    /**
     * @param value When the event destination is enabled, the specified event types are sent to the destinations. Default: `false`.
     */
    @JvmName("dlgjuutqmqrrwtpq")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value An object that defines an Amazon Kinesis Data Firehose destination for email events. See kinesis_firehose_destination below.
     */
    @JvmName("bpwwkfelonbbhtdi")
    public suspend
    fun kinesisFirehoseDestination(`value`: Output<ConfigurationSetEventDestinationEventDestinationKinesisFirehoseDestinationArgs>) {
        this.kinesisFirehoseDestination = value
    }

    /**
     * @param value An array that specifies which events the Amazon SES API v2 should send to the destinations. Valid values: `SEND`, `REJECT`, `BOUNCE`, `COMPLAINT`, `DELIVERY`, `OPEN`, `CLICK`, `RENDERING_FAILURE`, `DELIVERY_DELAY`, `SUBSCRIPTION`.
     * The following arguments are optional:
     */
    @JvmName("wmnkqqgmfrddjljd")
    public suspend fun matchingEventTypes(`value`: Output<List<String>>) {
        this.matchingEventTypes = value
    }

    @JvmName("bncfhexseexfetsm")
    public suspend fun matchingEventTypes(vararg values: Output<String>) {
        this.matchingEventTypes = Output.all(values.asList())
    }

    /**
     * @param values An array that specifies which events the Amazon SES API v2 should send to the destinations. Valid values: `SEND`, `REJECT`, `BOUNCE`, `COMPLAINT`, `DELIVERY`, `OPEN`, `CLICK`, `RENDERING_FAILURE`, `DELIVERY_DELAY`, `SUBSCRIPTION`.
     * The following arguments are optional:
     */
    @JvmName("njnmgkvkghfcqpkg")
    public suspend fun matchingEventTypes(values: List<Output<String>>) {
        this.matchingEventTypes = Output.all(values)
    }

    /**
     * @param value An object that defines an Amazon Pinpoint project destination for email events. See pinpoint_destination below.
     */
    @JvmName("brlhyxmsxtqocbue")
    public suspend
    fun pinpointDestination(`value`: Output<ConfigurationSetEventDestinationEventDestinationPinpointDestinationArgs>) {
        this.pinpointDestination = value
    }

    /**
     * @param value An object that defines an Amazon SNS destination for email events. See sns_destination below.
     */
    @JvmName("qmuqyfjcxyscnano")
    public suspend
    fun snsDestination(`value`: Output<ConfigurationSetEventDestinationEventDestinationSnsDestinationArgs>) {
        this.snsDestination = value
    }

    /**
     * @param value An object that defines an Amazon CloudWatch destination for email events. See cloud_watch_destination below
     */
    @JvmName("oavgiaukaeavdqow")
    public suspend
    fun cloudWatchDestination(`value`: ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudWatchDestination = mapped
    }

    /**
     * @param argument An object that defines an Amazon CloudWatch destination for email events. See cloud_watch_destination below
     */
    @JvmName("fegifoffyvyoggrc")
    public suspend
    fun cloudWatchDestination(argument: suspend ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.cloudWatchDestination = mapped
    }

    /**
     * @param value When the event destination is enabled, the specified event types are sent to the destinations. Default: `false`.
     */
    @JvmName("sesinbeilihraykx")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value An object that defines an Amazon Kinesis Data Firehose destination for email events. See kinesis_firehose_destination below.
     */
    @JvmName("gowrtdfddhsqhbwk")
    public suspend
    fun kinesisFirehoseDestination(`value`: ConfigurationSetEventDestinationEventDestinationKinesisFirehoseDestinationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kinesisFirehoseDestination = mapped
    }

    /**
     * @param argument An object that defines an Amazon Kinesis Data Firehose destination for email events. See kinesis_firehose_destination below.
     */
    @JvmName("vucwthisltutebka")
    public suspend
    fun kinesisFirehoseDestination(argument: suspend ConfigurationSetEventDestinationEventDestinationKinesisFirehoseDestinationArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConfigurationSetEventDestinationEventDestinationKinesisFirehoseDestinationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.kinesisFirehoseDestination = mapped
    }

    /**
     * @param value An array that specifies which events the Amazon SES API v2 should send to the destinations. Valid values: `SEND`, `REJECT`, `BOUNCE`, `COMPLAINT`, `DELIVERY`, `OPEN`, `CLICK`, `RENDERING_FAILURE`, `DELIVERY_DELAY`, `SUBSCRIPTION`.
     * The following arguments are optional:
     */
    @JvmName("sjeohksimyiuxppn")
    public suspend fun matchingEventTypes(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchingEventTypes = mapped
    }

    /**
     * @param values An array that specifies which events the Amazon SES API v2 should send to the destinations. Valid values: `SEND`, `REJECT`, `BOUNCE`, `COMPLAINT`, `DELIVERY`, `OPEN`, `CLICK`, `RENDERING_FAILURE`, `DELIVERY_DELAY`, `SUBSCRIPTION`.
     * The following arguments are optional:
     */
    @JvmName("vobxofpufasldsjv")
    public suspend fun matchingEventTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchingEventTypes = mapped
    }

    /**
     * @param value An object that defines an Amazon Pinpoint project destination for email events. See pinpoint_destination below.
     */
    @JvmName("cyirbnpmpfxbhirx")
    public suspend
    fun pinpointDestination(`value`: ConfigurationSetEventDestinationEventDestinationPinpointDestinationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pinpointDestination = mapped
    }

    /**
     * @param argument An object that defines an Amazon Pinpoint project destination for email events. See pinpoint_destination below.
     */
    @JvmName("ddylwwtpmxmlbjsq")
    public suspend
    fun pinpointDestination(argument: suspend ConfigurationSetEventDestinationEventDestinationPinpointDestinationArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConfigurationSetEventDestinationEventDestinationPinpointDestinationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.pinpointDestination = mapped
    }

    /**
     * @param value An object that defines an Amazon SNS destination for email events. See sns_destination below.
     */
    @JvmName("gfghvgoouybqthkf")
    public suspend
    fun snsDestination(`value`: ConfigurationSetEventDestinationEventDestinationSnsDestinationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snsDestination = mapped
    }

    /**
     * @param argument An object that defines an Amazon SNS destination for email events. See sns_destination below.
     */
    @JvmName("nxxxvgvrwipkhays")
    public suspend
    fun snsDestination(argument: suspend ConfigurationSetEventDestinationEventDestinationSnsDestinationArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConfigurationSetEventDestinationEventDestinationSnsDestinationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.snsDestination = mapped
    }

    internal fun build(): ConfigurationSetEventDestinationEventDestinationArgs =
        ConfigurationSetEventDestinationEventDestinationArgs(
            cloudWatchDestination = cloudWatchDestination,
            enabled = enabled,
            kinesisFirehoseDestination = kinesisFirehoseDestination,
            matchingEventTypes = matchingEventTypes ?: throw PulumiNullFieldException("matchingEventTypes"),
            pinpointDestination = pinpointDestination,
            snsDestination = snsDestination,
        )
}
