@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin.inputs

import com.pulumi.aws.sesv2.inputs.ConfigurationSetEventDestinationEventDestinationKinesisFirehoseDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deliveryStreamArn The Amazon Resource Name (ARN) of the Amazon Kinesis Data Firehose stream that the Amazon SES API v2 sends email events to.
 * @property iamRoleArn The Amazon Resource Name (ARN) of the IAM role that the Amazon SES API v2 uses to send email events to the Amazon Kinesis Data Firehose stream.
 */
public data class ConfigurationSetEventDestinationEventDestinationKinesisFirehoseDestinationArgs(
    public val deliveryStreamArn: Output<String>,
    public val iamRoleArn: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.sesv2.inputs.ConfigurationSetEventDestinationEventDestinationKinesisFirehoseDestinationArgs> {
    override fun toJava():
        com.pulumi.aws.sesv2.inputs.ConfigurationSetEventDestinationEventDestinationKinesisFirehoseDestinationArgs =
        com.pulumi.aws.sesv2.inputs.ConfigurationSetEventDestinationEventDestinationKinesisFirehoseDestinationArgs.builder()
            .deliveryStreamArn(deliveryStreamArn.applyValue({ args0 -> args0 }))
            .iamRoleArn(iamRoleArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigurationSetEventDestinationEventDestinationKinesisFirehoseDestinationArgs].
 */
@PulumiTagMarker
public class ConfigurationSetEventDestinationEventDestinationKinesisFirehoseDestinationArgsBuilder
internal constructor() {
    private var deliveryStreamArn: Output<String>? = null

    private var iamRoleArn: Output<String>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the Amazon Kinesis Data Firehose stream that the Amazon SES API v2 sends email events to.
     */
    @JvmName("rxnvfhetbjfrntmw")
    public suspend fun deliveryStreamArn(`value`: Output<String>) {
        this.deliveryStreamArn = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the IAM role that the Amazon SES API v2 uses to send email events to the Amazon Kinesis Data Firehose stream.
     */
    @JvmName("vmompqkudblvmrbl")
    public suspend fun iamRoleArn(`value`: Output<String>) {
        this.iamRoleArn = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Amazon Kinesis Data Firehose stream that the Amazon SES API v2 sends email events to.
     */
    @JvmName("iidysyqwfrhbbsbw")
    public suspend fun deliveryStreamArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deliveryStreamArn = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the IAM role that the Amazon SES API v2 uses to send email events to the Amazon Kinesis Data Firehose stream.
     */
    @JvmName("kpbgipcmadwmaxdg")
    public suspend fun iamRoleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.iamRoleArn = mapped
    }

    internal fun build():
        ConfigurationSetEventDestinationEventDestinationKinesisFirehoseDestinationArgs =
        ConfigurationSetEventDestinationEventDestinationKinesisFirehoseDestinationArgs(
            deliveryStreamArn = deliveryStreamArn ?: throw PulumiNullFieldException("deliveryStreamArn"),
            iamRoleArn = iamRoleArn ?: throw PulumiNullFieldException("iamRoleArn"),
        )
}
