@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin.inputs

import com.pulumi.aws.sesv2.inputs.ConfigurationSetTrackingOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property customRedirectDomain The domain to use for tracking open and click events.
 */
public data class ConfigurationSetTrackingOptionsArgs(
    public val customRedirectDomain: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.sesv2.inputs.ConfigurationSetTrackingOptionsArgs> {
    override fun toJava(): com.pulumi.aws.sesv2.inputs.ConfigurationSetTrackingOptionsArgs =
        com.pulumi.aws.sesv2.inputs.ConfigurationSetTrackingOptionsArgs.builder()
            .customRedirectDomain(customRedirectDomain.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigurationSetTrackingOptionsArgs].
 */
@PulumiTagMarker
public class ConfigurationSetTrackingOptionsArgsBuilder internal constructor() {
    private var customRedirectDomain: Output<String>? = null

    /**
     * @param value The domain to use for tracking open and click events.
     */
    @JvmName("mxddhrbyvuowvmcc")
    public suspend fun customRedirectDomain(`value`: Output<String>) {
        this.customRedirectDomain = value
    }

    /**
     * @param value The domain to use for tracking open and click events.
     */
    @JvmName("ulwchcpudvlkimfj")
    public suspend fun customRedirectDomain(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customRedirectDomain = mapped
    }

    internal fun build(): ConfigurationSetTrackingOptionsArgs = ConfigurationSetTrackingOptionsArgs(
        customRedirectDomain = customRedirectDomain ?: throw
            PulumiNullFieldException("customRedirectDomain"),
    )
}
