@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin.inputs

import com.pulumi.aws.sesv2.inputs.ContactListTopicArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property defaultSubscriptionStatus The default subscription status to be applied to a contact if the contact has not noted their preference for subscribing to a topic.
 * @property description A description of what the topic is about, which the contact will see.
 * @property displayName The name of the topic the contact will see.
 * @property topicName The name of the topic.
 * The following arguments are optional:
 */
public data class ContactListTopicArgs(
    public val defaultSubscriptionStatus: Output<String>,
    public val description: Output<String>? = null,
    public val displayName: Output<String>,
    public val topicName: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.sesv2.inputs.ContactListTopicArgs> {
    override fun toJava(): com.pulumi.aws.sesv2.inputs.ContactListTopicArgs =
        com.pulumi.aws.sesv2.inputs.ContactListTopicArgs.builder()
            .defaultSubscriptionStatus(defaultSubscriptionStatus.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName.applyValue({ args0 -> args0 }))
            .topicName(topicName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContactListTopicArgs].
 */
@PulumiTagMarker
public class ContactListTopicArgsBuilder internal constructor() {
    private var defaultSubscriptionStatus: Output<String>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var topicName: Output<String>? = null

    /**
     * @param value The default subscription status to be applied to a contact if the contact has not noted their preference for subscribing to a topic.
     */
    @JvmName("efbibmcijdwckjks")
    public suspend fun defaultSubscriptionStatus(`value`: Output<String>) {
        this.defaultSubscriptionStatus = value
    }

    /**
     * @param value A description of what the topic is about, which the contact will see.
     */
    @JvmName("efdweihtsnxwipwa")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the topic the contact will see.
     */
    @JvmName("dxywlwemomdqtfxg")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The name of the topic.
     * The following arguments are optional:
     */
    @JvmName("pkwhriypteggglvd")
    public suspend fun topicName(`value`: Output<String>) {
        this.topicName = value
    }

    /**
     * @param value The default subscription status to be applied to a contact if the contact has not noted their preference for subscribing to a topic.
     */
    @JvmName("klglchvpamwlkmng")
    public suspend fun defaultSubscriptionStatus(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultSubscriptionStatus = mapped
    }

    /**
     * @param value A description of what the topic is about, which the contact will see.
     */
    @JvmName("kdrkmwfgphpdevyr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the topic the contact will see.
     */
    @JvmName("uivwemmgtpivrymu")
    public suspend fun displayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The name of the topic.
     * The following arguments are optional:
     */
    @JvmName("mqiyfnhqiltdrimr")
    public suspend fun topicName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.topicName = mapped
    }

    internal fun build(): ContactListTopicArgs = ContactListTopicArgs(
        defaultSubscriptionStatus = defaultSubscriptionStatus ?: throw
            PulumiNullFieldException("defaultSubscriptionStatus"),
        description = description,
        displayName = displayName ?: throw PulumiNullFieldException("displayName"),
        topicName = topicName ?: throw PulumiNullFieldException("topicName"),
    )
}
