@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin.inputs

import com.pulumi.aws.sesv2.inputs.GetDedicatedIpPoolPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDedicatedIpPool.
 * @property poolName Name of the dedicated IP pool.
 * @property tags A map of tags attached to the pool.
 */
public data class GetDedicatedIpPoolPlainArgs(
    public val poolName: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sesv2.inputs.GetDedicatedIpPoolPlainArgs> {
    override fun toJava(): com.pulumi.aws.sesv2.inputs.GetDedicatedIpPoolPlainArgs =
        com.pulumi.aws.sesv2.inputs.GetDedicatedIpPoolPlainArgs.builder()
            .poolName(poolName.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetDedicatedIpPoolPlainArgs].
 */
@PulumiTagMarker
public class GetDedicatedIpPoolPlainArgsBuilder internal constructor() {
    private var poolName: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Name of the dedicated IP pool.
     */
    @JvmName("wvvynsakiacvtpka")
    public suspend fun poolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.poolName = mapped
    }

    /**
     * @param value A map of tags attached to the pool.
     */
    @JvmName("wjiogroolmxtvlhs")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A map of tags attached to the pool.
     */
    @JvmName("eiyybpdgnfcmpybs")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetDedicatedIpPoolPlainArgs = GetDedicatedIpPoolPlainArgs(
        poolName = poolName ?: throw PulumiNullFieldException("poolName"),
        tags = tags,
    )
}
