@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property cloudWatchDestination An object that defines an Amazon CloudWatch destination for email events. See cloud_watch_destination below
 * @property enabled When the event destination is enabled, the specified event types are sent to the destinations. Default: `false`.
 * @property kinesisFirehoseDestination An object that defines an Amazon Kinesis Data Firehose destination for email events. See kinesis_firehose_destination below.
 * @property matchingEventTypes An array that specifies which events the Amazon SES API v2 should send to the destinations. Valid values: `SEND`, `REJECT`, `BOUNCE`, `COMPLAINT`, `DELIVERY`, `OPEN`, `CLICK`, `RENDERING_FAILURE`, `DELIVERY_DELAY`, `SUBSCRIPTION`.
 * The following arguments are optional:
 * @property pinpointDestination An object that defines an Amazon Pinpoint project destination for email events. See pinpoint_destination below.
 * @property snsDestination An object that defines an Amazon SNS destination for email events. See sns_destination below.
 */
public data class ConfigurationSetEventDestinationEventDestination(
    public val cloudWatchDestination:
    ConfigurationSetEventDestinationEventDestinationCloudWatchDestination? = null,
    public val enabled: Boolean? = null,
    public val kinesisFirehoseDestination:
    ConfigurationSetEventDestinationEventDestinationKinesisFirehoseDestination? = null,
    public val matchingEventTypes: List<String>,
    public val pinpointDestination:
    ConfigurationSetEventDestinationEventDestinationPinpointDestination? = null,
    public val snsDestination: ConfigurationSetEventDestinationEventDestinationSnsDestination? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.sesv2.outputs.ConfigurationSetEventDestinationEventDestination):
            ConfigurationSetEventDestinationEventDestination =
            ConfigurationSetEventDestinationEventDestination(
                cloudWatchDestination = javaType.cloudWatchDestination().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.sesv2.kotlin.outputs.ConfigurationSetEventDestinationEventDestinationCloudWatchDestination.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
                kinesisFirehoseDestination = javaType.kinesisFirehoseDestination().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.sesv2.kotlin.outputs.ConfigurationSetEventDestinationEventDestinationKinesisFirehoseDestination.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                matchingEventTypes = javaType.matchingEventTypes().map({ args0 -> args0 }),
                pinpointDestination = javaType.pinpointDestination().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.sesv2.kotlin.outputs.ConfigurationSetEventDestinationEventDestinationPinpointDestination.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                snsDestination = javaType.snsDestination().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.sesv2.kotlin.outputs.ConfigurationSetEventDestinationEventDestinationSnsDestination.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
