@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property lastFreshStart The date and time (in Unix time) when the reputation metrics were last given a fresh start. When your account is given a fresh start, your reputation metrics are calculated starting from the date of the fresh start.
 * @property reputationMetricsEnabled If `true`, tracking of reputation metrics is enabled for the configuration set. If `false`, tracking of reputation metrics is disabled for the configuration set.
 */
public data class ConfigurationSetReputationOptions(
    public val lastFreshStart: String? = null,
    public val reputationMetricsEnabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sesv2.outputs.ConfigurationSetReputationOptions):
            ConfigurationSetReputationOptions = ConfigurationSetReputationOptions(
            lastFreshStart = javaType.lastFreshStart().map({ args0 -> args0 }).orElse(null),
            reputationMetricsEnabled = javaType.reputationMetricsEnabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
