@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property dashboardOptions Specifies additional settings for your VDM configuration as applicable to the Dashboard.
 * @property guardianOptions Specifies additional settings for your VDM configuration as applicable to the Guardian.
 */
public data class ConfigurationSetVdmOptions(
    public val dashboardOptions: ConfigurationSetVdmOptionsDashboardOptions? = null,
    public val guardianOptions: ConfigurationSetVdmOptionsGuardianOptions? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sesv2.outputs.ConfigurationSetVdmOptions):
            ConfigurationSetVdmOptions = ConfigurationSetVdmOptions(
            dashboardOptions = javaType.dashboardOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sesv2.kotlin.outputs.ConfigurationSetVdmOptionsDashboardOptions.Companion.toKotlin(args0)
                })
            }).orElse(null),
            guardianOptions = javaType.guardianOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sesv2.kotlin.outputs.ConfigurationSetVdmOptionsGuardianOptions.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
