@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property defaultSubscriptionStatus The default subscription status to be applied to a contact if the contact has not noted their preference for subscribing to a topic.
 * @property description A description of what the topic is about, which the contact will see.
 * @property displayName The name of the topic the contact will see.
 * @property topicName The name of the topic.
 * The following arguments are optional:
 */
public data class ContactListTopic(
    public val defaultSubscriptionStatus: String,
    public val description: String? = null,
    public val displayName: String,
    public val topicName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sesv2.outputs.ContactListTopic): ContactListTopic =
            ContactListTopic(
                defaultSubscriptionStatus = javaType.defaultSubscriptionStatus(),
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                displayName = javaType.displayName(),
                topicName = javaType.topicName(),
            )
    }
}
